@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val fieldToMatch:
    Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs>? = null,
    public val textTransformations:
    Output<List<RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRegexPatternSetReferenceStatementArgsBuilder internal
constructor() {
    private var arn: Output<String>? = null

    private var fieldToMatch:
        Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
     */
    @JvmName("xfabukxhsodeexdv")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("oakjxenpfbkrkthn")
    public suspend
    fun fieldToMatch(`value`: Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("akjpoulbttoyetqe")
    public suspend
    fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("skgkgbvojulagsby")
    public suspend fun textTransformations(
        vararg
        values: Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("yejweiwmtiyknexc")
    public suspend
    fun textTransformations(values: List<Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
     */
    @JvmName("koqejbafdwcnwsci")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("klhotbxgmchqjali")
    public suspend
    fun fieldToMatch(`value`: RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("xbcmfewkhdtupwke")
    public suspend
    fun fieldToMatch(argument: suspend RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("dgastkrqvaaqydib")
    public suspend
    fun textTransformations(`value`: List<RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("knkdhoafgdxvvtpc")
    public suspend
    fun textTransformations(argument: List<suspend RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("ylttmewohejmmcsf")
    public suspend fun textTransformations(
        vararg
        argument: suspend RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("txhvfbniprnchncd")
    public suspend
    fun textTransformations(argument: suspend RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("rkcfwabhdadlpdvy")
    public suspend fun textTransformations(
        vararg
        values: RuleGroupRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs =
        RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            fieldToMatch = fieldToMatch,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
