@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property oversizeHandling What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`
 */
public data class RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs(
    public val oversizeHandling: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs.builder()
            .oversizeHandling(oversizeHandling?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgsBuilder
internal constructor() {
    private var oversizeHandling: Output<String>? = null

    /**
     * @param value What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`
     */
    @JvmName("xdcgcbtmciqhynpo")
    public suspend fun oversizeHandling(`value`: Output<String>) {
        this.oversizeHandling = value
    }

    /**
     * @param value What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`
     */
    @JvmName("cbmytcjvsfeqyojb")
    public suspend fun oversizeHandling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oversizeHandling = mapped
    }

    internal fun build(): RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs =
        RuleGroupRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs(
            oversizeHandling = oversizeHandling,
        )
}
