@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator The operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property size The size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementSizeConstraintStatementArgs(
    public val comparisonOperator: Output<String>,
    public val fieldToMatch: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs>? =
        null,
    public val size: Output<Int>,
    public val textTransformations:
    Output<List<RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(size.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementSizeConstraintStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementSizeConstraintStatementArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var fieldToMatch: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs>? =
        null

    private var size: Output<Int>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs>>? = null

    /**
     * @param value The operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
     */
    @JvmName("xtndvkyukxlteoec")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("diqqjvkrjaaudclv")
    public suspend
    fun fieldToMatch(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value The size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
     */
    @JvmName("sgwoijfyprjvysyn")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("pooyamcykvccghdv")
    public suspend
    fun textTransformations(`value`: Output<List<RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("qqaifyfuranniysp")
    public suspend fun textTransformations(
        vararg
        values: Output<RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("kjiebexucnabsskc")
    public suspend
    fun textTransformations(values: List<Output<RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
     */
    @JvmName("swnqysunaepihpni")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("cejrbwpkdwwxpcme")
    public suspend
    fun fieldToMatch(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("jegdeekiqswyrnev")
    public suspend
    fun fieldToMatch(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value The size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
     */
    @JvmName("kjwbtsqdlywpvufi")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("mekqdnlmrvssjkfn")
    public suspend
    fun textTransformations(`value`: List<RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("jomtfykqvilpukuv")
    public suspend
    fun textTransformations(argument: List<suspend RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("ldriftmirqebqqyg")
    public suspend fun textTransformations(
        vararg
        argument: suspend RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("kqkwivlelcumqudo")
    public suspend
    fun textTransformations(argument: suspend RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("blrdeeijechhnhbl")
    public suspend fun textTransformations(
        vararg
        values: RuleGroupRuleStatementSizeConstraintStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementSizeConstraintStatementArgs =
        RuleGroupRuleStatementSizeConstraintStatementArgs(
            comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
            fieldToMatch = fieldToMatch,
            size = size ?: throw PulumiNullFieldException("size"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
