@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property all An empty configuration block that is used for inspecting all headers.
 * @property excludedHeaders An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
 * @property includedHeaders An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
 */
public data class RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs(
    public val all:
    Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternAllArgs>? =
        null,
    public val excludedHeaders: Output<List<String>>? = null,
    public val includedHeaders: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs.builder()
            .all(all?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .excludedHeaders(excludedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedHeaders(includedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgsBuilder
internal constructor() {
    private var all:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternAllArgs>? =
        null

    private var excludedHeaders: Output<List<String>>? = null

    private var includedHeaders: Output<List<String>>? = null

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("pueabgydxqlvvqlj")
    public suspend
    fun all(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternAllArgs>) {
        this.all = value
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("kbyjbrfpkfvmqwbr")
    public suspend fun excludedHeaders(`value`: Output<List<String>>) {
        this.excludedHeaders = value
    }

    @JvmName("jxwtxowggdmsfyuf")
    public suspend fun excludedHeaders(vararg values: Output<String>) {
        this.excludedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("qnveuwhexjmaeimu")
    public suspend fun excludedHeaders(values: List<Output<String>>) {
        this.excludedHeaders = Output.all(values)
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("khsxqdgqmapvepji")
    public suspend fun includedHeaders(`value`: Output<List<String>>) {
        this.includedHeaders = value
    }

    @JvmName("kwlvjcieixktlrfo")
    public suspend fun includedHeaders(vararg values: Output<String>) {
        this.includedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("crojtyqlenrsxbuv")
    public suspend fun includedHeaders(values: List<Output<String>>) {
        this.includedHeaders = Output.all(values)
    }

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("bciqbqdjvsllkdpc")
    public suspend
    fun all(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternAllArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.all = mapped
    }

    /**
     * @param argument An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("vxlluiephwcbgdjm")
    public suspend
    fun all(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternAllArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternAllArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.all = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("qhabpaowfmvhrcjr")
    public suspend fun excludedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("ipprudyaxxoxxjnx")
    public suspend fun excludedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("aikbtdxhhyfvehxf")
    public suspend fun includedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("pdyimqklpeppprov")
    public suspend fun includedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    internal fun build():
        RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs =
        RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderMatchPatternArgs(
            all = all,
            excludedHeaders = excludedHeaders,
            includedHeaders = includedHeaders,
        )
}
