@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headers: Output<List<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchMethodArgs>? = null,
    public val queryString:
    Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryStringArgs>? = null,
    public val singleHeader:
    Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument:
    Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementXssMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headers: Output<List<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchMethodArgs>? = null

    private var queryString:
        Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("rngejpraxknyadnl")
    public suspend
    fun allQueryArguments(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("rsdntnnibdrnqeoh")
    public suspend
    fun body(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("uyfetdurxshmulbj")
    public suspend
    fun cookies(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("nficorgsajnitaun")
    public suspend
    fun headers(`value`: Output<List<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("rmmdwyqplfagywcv")
    public suspend fun headers(
        vararg
        values: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("nuobwhiyctgtordk")
    public suspend
    fun headers(values: List<Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rrpphcpkosblymdb")
    public suspend
    fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("pfakdgscjrmdfepd")
    public suspend
    fun jsonBody(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("uxkjttjevtqusyuk")
    public suspend
    fun method(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("wltdslejebffwxyp")
    public suspend
    fun queryString(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("coxepfwuukpphdoo")
    public suspend
    fun singleHeader(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("egrcjgwehnuqehdm")
    public suspend
    fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("waughplknpmuvupn")
    public suspend
    fun uriPath(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("bdgfqatckaisalih")
    public suspend
    fun allQueryArguments(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("uqiowornwrpgsika")
    public suspend
    fun allQueryArguments(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("asipoarcyegjkmyl")
    public suspend fun body(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("ylmileqdxotnxnsk")
    public suspend
    fun body(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("rawjqigyvwcayhdc")
    public suspend
    fun cookies(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("xyevtvbtbkmmknwn")
    public suspend
    fun cookies(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("octukaqkkluxuhgi")
    public suspend
    fun headers(`value`: List<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("dvyntxwajjgixrwk")
    public suspend
    fun headers(argument: List<suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("lwbbjepohnrlulyh")
    public suspend fun headers(
        vararg
        argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("ttuefatxasofhmmj")
    public suspend
    fun headers(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("fremifmaijejopre")
    public suspend fun headers(
        vararg
        values: RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("uxqkiaqbocpsjaos")
    public suspend
    fun ja3Fingerprint(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mudsxkvneleopdwy")
    public suspend
    fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("umslrdvwvfylieux")
    public suspend
    fun jsonBody(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("ukprwnkbbrpibcgk")
    public suspend
    fun jsonBody(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("eqsenbabymkhonfq")
    public suspend
    fun method(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("fwqmxkhtodpcrjry")
    public suspend
    fun method(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("bkhltbdigwrjphmo")
    public suspend
    fun queryString(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("gakwviwalqwwpscf")
    public suspend
    fun queryString(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("xmfmrrnvyerqvaqf")
    public suspend
    fun singleHeader(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("xsnuvchcqtjhqxrg")
    public suspend
    fun singleHeader(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("plciggufpdccncvq")
    public suspend
    fun singleQueryArgument(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("bulocequwjnnhsqp")
    public suspend
    fun singleQueryArgument(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("iqcahhwsgbocykyw")
    public suspend
    fun uriPath(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("sjiffjaqfrkkdkdq")
    public suspend
    fun uriPath(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs =
        RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
