@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property requestBodies Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
 */
public data class WebAclAssociationConfigArgs(
    public val requestBodies: Output<List<WebAclAssociationConfigRequestBodyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigArgs.builder()
            .requestBodies(
                requestBodies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclAssociationConfigArgs].
 */
@PulumiTagMarker
public class WebAclAssociationConfigArgsBuilder internal constructor() {
    private var requestBodies: Output<List<WebAclAssociationConfigRequestBodyArgs>>? = null

    /**
     * @param value Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("axovbcltiwsjwjyh")
    public suspend fun requestBodies(`value`: Output<List<WebAclAssociationConfigRequestBodyArgs>>) {
        this.requestBodies = value
    }

    @JvmName("utdxokikbggoqjpa")
    public suspend fun requestBodies(vararg values: Output<WebAclAssociationConfigRequestBodyArgs>) {
        this.requestBodies = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("aghayisahjkvvtnd")
    public suspend fun requestBodies(values: List<Output<WebAclAssociationConfigRequestBodyArgs>>) {
        this.requestBodies = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("efsppqjwbdsevelh")
    public suspend fun requestBodies(`value`: List<WebAclAssociationConfigRequestBodyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodies = mapped
    }

    /**
     * @param argument Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("asldiofvbuudceee")
    public suspend
    fun requestBodies(argument: List<suspend WebAclAssociationConfigRequestBodyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestBodies = mapped
    }

    /**
     * @param argument Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("uyajkbhdvlqggfpf")
    public suspend fun requestBodies(
        vararg
        argument: suspend WebAclAssociationConfigRequestBodyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestBodies = mapped
    }

    /**
     * @param argument Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("tokxdwbrjykohhlp")
    public suspend
    fun requestBodies(argument: suspend WebAclAssociationConfigRequestBodyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclAssociationConfigRequestBodyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requestBodies = mapped
    }

    /**
     * @param values Customizes the request body that your protected resource forward to AWS WAF for inspection. See `request_body` below for details.
     */
    @JvmName("shmrexktrgpnqqfy")
    public suspend fun requestBodies(vararg values: WebAclAssociationConfigRequestBodyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestBodies = mapped
    }

    internal fun build(): WebAclAssociationConfigArgs = WebAclAssociationConfigArgs(
        requestBodies = requestBodies,
    )
}
