@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cloudfronts Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
 */
public data class WebAclAssociationConfigRequestBodyArgs(
    public val cloudfronts: Output<List<WebAclAssociationConfigRequestBodyCloudfrontArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs =
        com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs.builder()
            .cloudfronts(
                cloudfronts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclAssociationConfigRequestBodyArgs].
 */
@PulumiTagMarker
public class WebAclAssociationConfigRequestBodyArgsBuilder internal constructor() {
    private var cloudfronts: Output<List<WebAclAssociationConfigRequestBodyCloudfrontArgs>>? = null

    /**
     * @param value Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("kkbahtrbwbsudqcq")
    public suspend
    fun cloudfronts(`value`: Output<List<WebAclAssociationConfigRequestBodyCloudfrontArgs>>) {
        this.cloudfronts = value
    }

    @JvmName("sssfllpgblhifovf")
    public suspend fun cloudfronts(
        vararg
        values: Output<WebAclAssociationConfigRequestBodyCloudfrontArgs>,
    ) {
        this.cloudfronts = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("qksnysdcydkpdtrv")
    public suspend
    fun cloudfronts(values: List<Output<WebAclAssociationConfigRequestBodyCloudfrontArgs>>) {
        this.cloudfronts = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("itquljreshlvqjhs")
    public suspend fun cloudfronts(`value`: List<WebAclAssociationConfigRequestBodyCloudfrontArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudfronts = mapped
    }

    /**
     * @param argument Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("vwekojprdosfbbsc")
    public suspend
    fun cloudfronts(argument: List<suspend WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudfronts = mapped
    }

    /**
     * @param argument Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("ffrieguaeybnghys")
    public suspend fun cloudfronts(
        vararg
        argument: suspend WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudfronts = mapped
    }

    /**
     * @param argument Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("rdmxakswwqjmgutr")
    public suspend
    fun cloudfronts(argument: suspend WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudfronts = mapped
    }

    /**
     * @param values Customizes the request body that your protected CloudFront distributions forward to AWS WAF for inspection. See `cloudfront` below for details.
     */
    @JvmName("rlxulqiwrftvmxhg")
    public suspend fun cloudfronts(vararg values: WebAclAssociationConfigRequestBodyCloudfrontArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudfronts = mapped
    }

    internal fun build(): WebAclAssociationConfigRequestBodyArgs =
        WebAclAssociationConfigRequestBodyArgs(
            cloudfronts = cloudfronts,
        )
}
