@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigImmunityTimePropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property immunityTime The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by AWS WAF. The default setting is 300.
 */
public data class WebAclCaptchaConfigImmunityTimePropertyArgs(
    public val immunityTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigImmunityTimePropertyArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigImmunityTimePropertyArgs =
        com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigImmunityTimePropertyArgs.builder()
            .immunityTime(immunityTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclCaptchaConfigImmunityTimePropertyArgs].
 */
@PulumiTagMarker
public class WebAclCaptchaConfigImmunityTimePropertyArgsBuilder internal constructor() {
    private var immunityTime: Output<Int>? = null

    /**
     * @param value The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by AWS WAF. The default setting is 300.
     */
    @JvmName("celnfapsvyksmoqw")
    public suspend fun immunityTime(`value`: Output<Int>) {
        this.immunityTime = value
    }

    /**
     * @param value The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by AWS WAF. The default setting is 300.
     */
    @JvmName("xsbgceloydqfhfum")
    public suspend fun immunityTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immunityTime = mapped
    }

    internal fun build(): WebAclCaptchaConfigImmunityTimePropertyArgs =
        WebAclCaptchaConfigImmunityTimePropertyArgs(
            immunityTime = immunityTime,
        )
}
