@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclCustomResponseBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content Payload of the custom response.
 * @property contentType Type of content in the payload that you are defining in the `content` argument. Valid values are `TEXT_PLAIN`, `TEXT_HTML`, or `APPLICATION_JSON`.
 * @property key Unique key identifying the custom response body. This is referenced by the `custom_response_body_key` argument in the `custom_response` block.
 */
public data class WebAclCustomResponseBodyArgs(
    public val content: Output<String>,
    public val contentType: Output<String>,
    public val key: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclCustomResponseBodyArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclCustomResponseBodyArgs =
        com.pulumi.aws.wafv2.inputs.WebAclCustomResponseBodyArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclCustomResponseBodyArgs].
 */
@PulumiTagMarker
public class WebAclCustomResponseBodyArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value Payload of the custom response.
     */
    @JvmName("jdmseiwxbxlvditk")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Type of content in the payload that you are defining in the `content` argument. Valid values are `TEXT_PLAIN`, `TEXT_HTML`, or `APPLICATION_JSON`.
     */
    @JvmName("aqbikfyouusiahvb")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Unique key identifying the custom response body. This is referenced by the `custom_response_body_key` argument in the `custom_response` block.
     */
    @JvmName("arkjsdfngqrqngfr")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Payload of the custom response.
     */
    @JvmName("gqyafmrponvbdbbm")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Type of content in the payload that you are defining in the `content` argument. Valid values are `TEXT_PLAIN`, `TEXT_HTML`, or `APPLICATION_JSON`.
     */
    @JvmName("qatpmynklmvbrgfs")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Unique key identifying the custom response body. This is referenced by the `custom_response_body_key` argument in the `custom_response` block.
     */
    @JvmName("vihrsongfdtoyeol")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): WebAclCustomResponseBodyArgs = WebAclCustomResponseBodyArgs(
        content = content ?: throw PulumiNullFieldException("content"),
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        key = key ?: throw PulumiNullFieldException("key"),
    )
}
