@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allow Specifies that AWS WAF should allow requests by default. See `allow` below for details.
 * @property block Specifies that AWS WAF should block requests by default. See `block` below for details.
 */
public data class WebAclDefaultActionArgs(
    public val allow: Output<WebAclDefaultActionAllowArgs>? = null,
    public val block: Output<WebAclDefaultActionBlockArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclDefaultActionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclDefaultActionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclDefaultActionArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .block(block?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclDefaultActionArgs].
 */
@PulumiTagMarker
public class WebAclDefaultActionArgsBuilder internal constructor() {
    private var allow: Output<WebAclDefaultActionAllowArgs>? = null

    private var block: Output<WebAclDefaultActionBlockArgs>? = null

    /**
     * @param value Specifies that AWS WAF should allow requests by default. See `allow` below for details.
     */
    @JvmName("ijfoleivfagvwbfe")
    public suspend fun allow(`value`: Output<WebAclDefaultActionAllowArgs>) {
        this.allow = value
    }

    /**
     * @param value Specifies that AWS WAF should block requests by default. See `block` below for details.
     */
    @JvmName("yjjkppixnvdphgqa")
    public suspend fun block(`value`: Output<WebAclDefaultActionBlockArgs>) {
        this.block = value
    }

    /**
     * @param value Specifies that AWS WAF should allow requests by default. See `allow` below for details.
     */
    @JvmName("umjiihwdcmuhlhmn")
    public suspend fun allow(`value`: WebAclDefaultActionAllowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param argument Specifies that AWS WAF should allow requests by default. See `allow` below for details.
     */
    @JvmName("cdjsumocrupdkkjg")
    public suspend fun allow(argument: suspend WebAclDefaultActionAllowArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionAllowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param value Specifies that AWS WAF should block requests by default. See `block` below for details.
     */
    @JvmName("vbnnqmkumttiulld")
    public suspend fun block(`value`: WebAclDefaultActionBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.block = mapped
    }

    /**
     * @param argument Specifies that AWS WAF should block requests by default. See `block` below for details.
     */
    @JvmName("rbxcewgbkrjmehsl")
    public suspend fun block(argument: suspend WebAclDefaultActionBlockArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionBlockArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.block = mapped
    }

    internal fun build(): WebAclDefaultActionArgs = WebAclDefaultActionArgs(
        allow = allow,
        block = block,
    )
}
