@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customResponse Defines a custom response for the web request. See `custom_response` below for details.
 */
public data class WebAclDefaultActionBlockArgs(
    public val customResponse: Output<WebAclDefaultActionBlockCustomResponseArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclDefaultActionBlockArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclDefaultActionBlockArgs =
        com.pulumi.aws.wafv2.inputs.WebAclDefaultActionBlockArgs.builder()
            .customResponse(
                customResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclDefaultActionBlockArgs].
 */
@PulumiTagMarker
public class WebAclDefaultActionBlockArgsBuilder internal constructor() {
    private var customResponse: Output<WebAclDefaultActionBlockCustomResponseArgs>? = null

    /**
     * @param value Defines a custom response for the web request. See `custom_response` below for details.
     */
    @JvmName("ssebgnhaaxqnjaoo")
    public suspend fun customResponse(`value`: Output<WebAclDefaultActionBlockCustomResponseArgs>) {
        this.customResponse = value
    }

    /**
     * @param value Defines a custom response for the web request. See `custom_response` below for details.
     */
    @JvmName("efapdrtjdbxwgsxy")
    public suspend fun customResponse(`value`: WebAclDefaultActionBlockCustomResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponse = mapped
    }

    /**
     * @param argument Defines a custom response for the web request. See `custom_response` below for details.
     */
    @JvmName("gmmwxqwvdskfsskl")
    public suspend
    fun customResponse(argument: suspend WebAclDefaultActionBlockCustomResponseArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionBlockCustomResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customResponse = mapped
    }

    internal fun build(): WebAclDefaultActionBlockArgs = WebAclDefaultActionBlockArgs(
        customResponse = customResponse,
    )
}
