@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property defaultBehavior Default handling for logs that don't match any of the specified filtering conditions. Valid values for `default_behavior` are `KEEP` or `DROP`.
 * @property filters Filter(s) that you want to apply to the logs. See Filter below for more details.
 */
public data class WebAclLoggingConfigurationLoggingFilterArgs(
    public val defaultBehavior: Output<String>,
    public val filters: Output<List<WebAclLoggingConfigurationLoggingFilterFilterArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs =
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs.builder()
            .defaultBehavior(defaultBehavior.applyValue({ args0 -> args0 }))
            .filters(
                filters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclLoggingConfigurationLoggingFilterArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationLoggingFilterArgsBuilder internal constructor() {
    private var defaultBehavior: Output<String>? = null

    private var filters: Output<List<WebAclLoggingConfigurationLoggingFilterFilterArgs>>? = null

    /**
     * @param value Default handling for logs that don't match any of the specified filtering conditions. Valid values for `default_behavior` are `KEEP` or `DROP`.
     */
    @JvmName("gvjpybftdujukhdv")
    public suspend fun defaultBehavior(`value`: Output<String>) {
        this.defaultBehavior = value
    }

    /**
     * @param value Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("gdxdheetqvfaecxf")
    public suspend
    fun filters(`value`: Output<List<WebAclLoggingConfigurationLoggingFilterFilterArgs>>) {
        this.filters = value
    }

    @JvmName("ikbrsyhqvwusnoxc")
    public suspend fun filters(
        vararg
        values: Output<WebAclLoggingConfigurationLoggingFilterFilterArgs>,
    ) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("uyaodbbbdksbjgqo")
    public suspend
    fun filters(values: List<Output<WebAclLoggingConfigurationLoggingFilterFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Default handling for logs that don't match any of the specified filtering conditions. Valid values for `default_behavior` are `KEEP` or `DROP`.
     */
    @JvmName("gbemvrkqfmirwgsl")
    public suspend fun defaultBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultBehavior = mapped
    }

    /**
     * @param value Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("kysvnfgfktocxnpt")
    public suspend fun filters(`value`: List<WebAclLoggingConfigurationLoggingFilterFilterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("omxdlyucrqawwlic")
    public suspend
    fun filters(argument: List<suspend WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("sutphhwbfuyrjpkw")
    public suspend fun filters(
        vararg
        argument: suspend WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("yipgjoqdrfknekyy")
    public suspend
    fun filters(argument: suspend WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values Filter(s) that you want to apply to the logs. See Filter below for more details.
     */
    @JvmName("dkoaqelnlyabrkal")
    public suspend fun filters(vararg values: WebAclLoggingConfigurationLoggingFilterFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    internal fun build(): WebAclLoggingConfigurationLoggingFilterArgs =
        WebAclLoggingConfigurationLoggingFilterArgs(
            defaultBehavior = defaultBehavior ?: throw PulumiNullFieldException("defaultBehavior"),
            filters = filters ?: throw PulumiNullFieldException("filters"),
        )
}
