@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action Action setting that a log record must contain in order to meet the condition. Valid values for `action` are `ALLOW`, `BLOCK`, and `COUNT`.
 */
public data class WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs(
    public val action: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
            .action(action.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgsBuilder
internal constructor() {
    private var action: Output<String>? = null

    /**
     * @param value Action setting that a log record must contain in order to meet the condition. Valid values for `action` are `ALLOW`, `BLOCK`, and `COUNT`.
     */
    @JvmName("otdpukyimgxnhuut")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Action setting that a log record must contain in order to meet the condition. Valid values for `action` are `ALLOW`, `BLOCK`, and `COUNT`.
     */
    @JvmName("dvhesxilwbcrdrty")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    internal fun build(): WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs =
        WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs(
            action = action ?: throw PulumiNullFieldException("action"),
        )
}
