@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property method HTTP method to be redacted. It must be specified as an empty configuration block `{}`. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Whether to redact the query string. It must be specified as an empty configuration block `{}`. The query string is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader "single_header" refers to the redaction of a single header. For more information, please see the details below under Single Header.
 * @property uriPath Configuration block that redacts the request URI path. It should be specified as an empty configuration block `{}`. The URI path is the part of a web request that identifies a resource, such as `/images/daily-ad.jpg`.
 */
public data class WebAclLoggingConfigurationRedactedFieldArgs(
    public val method: Output<WebAclLoggingConfigurationRedactedFieldMethodArgs>? = null,
    public val queryString: Output<WebAclLoggingConfigurationRedactedFieldQueryStringArgs>? = null,
    public val singleHeader: Output<WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs>? = null,
    public val uriPath: Output<WebAclLoggingConfigurationRedactedFieldUriPathArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs =
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs.builder()
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclLoggingConfigurationRedactedFieldArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationRedactedFieldArgsBuilder internal constructor() {
    private var method: Output<WebAclLoggingConfigurationRedactedFieldMethodArgs>? = null

    private var queryString: Output<WebAclLoggingConfigurationRedactedFieldQueryStringArgs>? = null

    private var singleHeader: Output<WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs>? = null

    private var uriPath: Output<WebAclLoggingConfigurationRedactedFieldUriPathArgs>? = null

    /**
     * @param value HTTP method to be redacted. It must be specified as an empty configuration block `{}`. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("ixoxkvvhvcfbylmc")
    public suspend fun method(`value`: Output<WebAclLoggingConfigurationRedactedFieldMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Whether to redact the query string. It must be specified as an empty configuration block `{}`. The query string is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("pceoptfeiwelbfgo")
    public suspend
    fun queryString(`value`: Output<WebAclLoggingConfigurationRedactedFieldQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value "single_header" refers to the redaction of a single header. For more information, please see the details below under Single Header.
     */
    @JvmName("udvgthqjsqkqoudq")
    public suspend
    fun singleHeader(`value`: Output<WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Configuration block that redacts the request URI path. It should be specified as an empty configuration block `{}`. The URI path is the part of a web request that identifies a resource, such as `/images/daily-ad.jpg`.
     */
    @JvmName("tywiqomhkpoftgle")
    public suspend fun uriPath(`value`: Output<WebAclLoggingConfigurationRedactedFieldUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value HTTP method to be redacted. It must be specified as an empty configuration block `{}`. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("urohddisgssmvttc")
    public suspend fun method(`value`: WebAclLoggingConfigurationRedactedFieldMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument HTTP method to be redacted. It must be specified as an empty configuration block `{}`. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("qpkhusldnmyinsgs")
    public suspend
    fun method(argument: suspend WebAclLoggingConfigurationRedactedFieldMethodArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationRedactedFieldMethodArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Whether to redact the query string. It must be specified as an empty configuration block `{}`. The query string is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("lwegdijiqiokphqa")
    public suspend fun queryString(`value`: WebAclLoggingConfigurationRedactedFieldQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Whether to redact the query string. It must be specified as an empty configuration block `{}`. The query string is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("hjtwwtiujrjdfajo")
    public suspend
    fun queryString(argument: suspend WebAclLoggingConfigurationRedactedFieldQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationRedactedFieldQueryStringArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value "single_header" refers to the redaction of a single header. For more information, please see the details below under Single Header.
     */
    @JvmName("lxnnomqrxahqalkt")
    public suspend
    fun singleHeader(`value`: WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument "single_header" refers to the redaction of a single header. For more information, please see the details below under Single Header.
     */
    @JvmName("bohydveuqntygdor")
    public suspend
    fun singleHeader(argument: suspend WebAclLoggingConfigurationRedactedFieldSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationRedactedFieldSingleHeaderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Configuration block that redacts the request URI path. It should be specified as an empty configuration block `{}`. The URI path is the part of a web request that identifies a resource, such as `/images/daily-ad.jpg`.
     */
    @JvmName("kiddomkpkbkludkx")
    public suspend fun uriPath(`value`: WebAclLoggingConfigurationRedactedFieldUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Configuration block that redacts the request URI path. It should be specified as an empty configuration block `{}`. The URI path is the part of a web request that identifies a resource, such as `/images/daily-ad.jpg`.
     */
    @JvmName("tiwqtbfbpdvevudj")
    public suspend
    fun uriPath(argument: suspend WebAclLoggingConfigurationRedactedFieldUriPathArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationRedactedFieldUriPathArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclLoggingConfigurationRedactedFieldArgs =
        WebAclLoggingConfigurationRedactedFieldArgs(
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            uriPath = uriPath,
        )
}
