@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allow Instructs AWS WAF to allow the web request. See `allow` below for details.
 * @property block Instructs AWS WAF to block the web request. See `block` below for details.
 * @property captcha Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
 * @property challenge Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
 * @property count Instructs AWS WAF to count the web request and allow it. See `count` below for details.
 */
public data class WebAclRuleActionArgs(
    public val allow: Output<WebAclRuleActionAllowArgs>? = null,
    public val block: Output<WebAclRuleActionBlockArgs>? = null,
    public val captcha: Output<WebAclRuleActionCaptchaArgs>? = null,
    public val challenge: Output<WebAclRuleActionChallengeArgs>? = null,
    public val count: Output<WebAclRuleActionCountArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .block(block?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captcha(captcha?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .challenge(challenge?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .count(count?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleActionArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionArgsBuilder internal constructor() {
    private var allow: Output<WebAclRuleActionAllowArgs>? = null

    private var block: Output<WebAclRuleActionBlockArgs>? = null

    private var captcha: Output<WebAclRuleActionCaptchaArgs>? = null

    private var challenge: Output<WebAclRuleActionChallengeArgs>? = null

    private var count: Output<WebAclRuleActionCountArgs>? = null

    /**
     * @param value Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("mdiodqyemugwsuqn")
    public suspend fun allow(`value`: Output<WebAclRuleActionAllowArgs>) {
        this.allow = value
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("mimsrbmibqpkjdim")
    public suspend fun block(`value`: Output<WebAclRuleActionBlockArgs>) {
        this.block = value
    }

    /**
     * @param value Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("obmhhmqomdpbldrj")
    public suspend fun captcha(`value`: Output<WebAclRuleActionCaptchaArgs>) {
        this.captcha = value
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("yoiynfgwmrnjcisi")
    public suspend fun challenge(`value`: Output<WebAclRuleActionChallengeArgs>) {
        this.challenge = value
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("xnwjwbadrliarfuj")
    public suspend fun count(`value`: Output<WebAclRuleActionCountArgs>) {
        this.count = value
    }

    /**
     * @param value Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("jcrebuhvthxireca")
    public suspend fun allow(`value`: WebAclRuleActionAllowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param argument Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("ooscrekhgyxrsawv")
    public suspend fun allow(argument: suspend WebAclRuleActionAllowArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionAllowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("mogljepgfskuwmfb")
    public suspend fun block(`value`: WebAclRuleActionBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.block = mapped
    }

    /**
     * @param argument Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("yfgmcgouyoujpqah")
    public suspend fun block(argument: suspend WebAclRuleActionBlockArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionBlockArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.block = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("gwgofnndhndbeyck")
    public suspend fun captcha(`value`: WebAclRuleActionCaptchaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captcha = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("ddhcxfupacrhflpy")
    public suspend fun captcha(argument: suspend WebAclRuleActionCaptchaArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionCaptchaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.captcha = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("xqkdalfotepgcluo")
    public suspend fun challenge(`value`: WebAclRuleActionChallengeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.challenge = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("ytdytdxmupqxvlvk")
    public suspend fun challenge(argument: suspend WebAclRuleActionChallengeArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionChallengeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.challenge = mapped
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("pgoyrivtxswgdonv")
    public suspend fun count(`value`: WebAclRuleActionCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param argument Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("hjkrisoofaehjeto")
    public suspend fun count(argument: suspend WebAclRuleActionCountArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionCountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.count = mapped
    }

    internal fun build(): WebAclRuleActionArgs = WebAclRuleActionArgs(
        allow = allow,
        block = block,
        captcha = captcha,
        challenge = challenge,
        count = count,
    )
}
