@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customResponse Defines a custom response for the web request. See `custom_response` below for details.
 */
public data class WebAclRuleActionBlockArgs(
    public val customResponse: Output<WebAclRuleActionBlockCustomResponseArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockArgs.builder()
            .customResponse(
                customResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionBlockArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionBlockArgsBuilder internal constructor() {
    private var customResponse: Output<WebAclRuleActionBlockCustomResponseArgs>? = null

    /**
     * @param value Defines a custom response for the web request. See `custom_response` below for details.
     */
    @JvmName("vmkoynxxbshirbbj")
    public suspend fun customResponse(`value`: Output<WebAclRuleActionBlockCustomResponseArgs>) {
        this.customResponse = value
    }

    /**
     * @param value Defines a custom response for the web request. See `custom_response` below for details.
     */
    @JvmName("xjvvnlfipalwmdym")
    public suspend fun customResponse(`value`: WebAclRuleActionBlockCustomResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponse = mapped
    }

    /**
     * @param argument Defines a custom response for the web request. See `custom_response` below for details.
     */
    @JvmName("rfbvkkwhjjycomsy")
    public suspend
    fun customResponse(argument: suspend WebAclRuleActionBlockCustomResponseArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionBlockCustomResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customResponse = mapped
    }

    internal fun build(): WebAclRuleActionBlockArgs = WebAclRuleActionBlockArgs(
        customResponse = customResponse,
    )
}
