@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockCustomResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customResponseBodyKey References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
 * @property responseCode The HTTP status code to return to the client.
 * @property responseHeaders The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
 */
public data class WebAclRuleActionBlockCustomResponseArgs(
    public val customResponseBodyKey: Output<String>? = null,
    public val responseCode: Output<Int>,
    public val responseHeaders: Output<List<WebAclRuleActionBlockCustomResponseResponseHeaderArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockCustomResponseArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockCustomResponseArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionBlockCustomResponseArgs.builder()
            .customResponseBodyKey(customResponseBodyKey?.applyValue({ args0 -> args0 }))
            .responseCode(responseCode.applyValue({ args0 -> args0 }))
            .responseHeaders(
                responseHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionBlockCustomResponseArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionBlockCustomResponseArgsBuilder internal constructor() {
    private var customResponseBodyKey: Output<String>? = null

    private var responseCode: Output<Int>? = null

    private var responseHeaders: Output<List<WebAclRuleActionBlockCustomResponseResponseHeaderArgs>>? =
        null

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("dnbgosbnqftiphos")
    public suspend fun customResponseBodyKey(`value`: Output<String>) {
        this.customResponseBodyKey = value
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("otjhejhgplwcbcky")
    public suspend fun responseCode(`value`: Output<Int>) {
        this.responseCode = value
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("vrdlmtmnmkytgdgv")
    public suspend
    fun responseHeaders(`value`: Output<List<WebAclRuleActionBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = value
    }

    @JvmName("irjxgbaonwbgnlex")
    public suspend fun responseHeaders(
        vararg
        values: Output<WebAclRuleActionBlockCustomResponseResponseHeaderArgs>,
    ) {
        this.responseHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("lbalonddcqpumacr")
    public suspend
    fun responseHeaders(values: List<Output<WebAclRuleActionBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = Output.all(values)
    }

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("absbohawrnwyxvoh")
    public suspend fun customResponseBodyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponseBodyKey = mapped
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("nduyjblpxmgyijdv")
    public suspend fun responseCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseCode = mapped
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("ickqeitfhtxjeetb")
    public suspend
    fun responseHeaders(`value`: List<WebAclRuleActionBlockCustomResponseResponseHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("vgpxjkkquadcsdbn")
    public suspend
    fun responseHeaders(argument: List<suspend WebAclRuleActionBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionBlockCustomResponseResponseHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("jnnkfluixjspfyhp")
    public suspend fun responseHeaders(
        vararg
        argument: suspend WebAclRuleActionBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionBlockCustomResponseResponseHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("ygsmwrgrvesrwhqq")
    public suspend
    fun responseHeaders(argument: suspend WebAclRuleActionBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleActionBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("sfpcywprvmvqekfv")
    public suspend fun responseHeaders(
        vararg
        values: WebAclRuleActionBlockCustomResponseResponseHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    internal fun build(): WebAclRuleActionBlockCustomResponseArgs =
        WebAclRuleActionBlockCustomResponseArgs(
            customResponseBodyKey = customResponseBodyKey,
            responseCode = responseCode ?: throw PulumiNullFieldException("responseCode"),
            responseHeaders = responseHeaders,
        )
}
