@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See `custom_request_handling` below for details.
 */
public data class WebAclRuleActionCaptchaArgs(
    public val customRequestHandling: Output<WebAclRuleActionCaptchaCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionCaptchaArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionCaptchaArgsBuilder internal constructor() {
    private var customRequestHandling: Output<WebAclRuleActionCaptchaCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("mycuthggbendpxbq")
    public suspend
    fun customRequestHandling(`value`: Output<WebAclRuleActionCaptchaCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("kpdwkytryliegevm")
    public suspend
    fun customRequestHandling(`value`: WebAclRuleActionCaptchaCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("lbvyhocioibncmjf")
    public suspend
    fun customRequestHandling(argument: suspend WebAclRuleActionCaptchaCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionCaptchaCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): WebAclRuleActionCaptchaArgs = WebAclRuleActionCaptchaArgs(
        customRequestHandling = customRequestHandling,
    )
}
