@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
 */
public data class WebAclRuleActionChallengeCustomRequestHandlingArgs(
    public val insertHeaders:
    Output<List<WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeCustomRequestHandlingArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionChallengeCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionChallengeCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("hicrtreqegiarntp")
    public suspend
    fun insertHeaders(`value`: Output<List<WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("pvjkcoofsxtfsylv")
    public suspend fun insertHeaders(
        vararg
        values: Output<WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>,
    ) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("uvbnppslccnplppa")
    public suspend
    fun insertHeaders(values: List<Output<WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("fhiwqgninycebetw")
    public suspend
    fun insertHeaders(`value`: List<WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("hrcftxkuexwojjra")
    public suspend
    fun insertHeaders(argument: List<suspend WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("ybtucgqpimdipuaw")
    public suspend fun insertHeaders(
        vararg
        argument: suspend WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("ccxvbemlghxbyeia")
    public suspend
    fun insertHeaders(argument: suspend WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("axprrsjufgaxmmra")
    public suspend fun insertHeaders(
        vararg
        values: WebAclRuleActionChallengeCustomRequestHandlingInsertHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): WebAclRuleActionChallengeCustomRequestHandlingArgs =
        WebAclRuleActionChallengeCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
