@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
 */
public data class WebAclRuleActionCountCustomRequestHandlingArgs(
    public val insertHeaders:
    Output<List<WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountCustomRequestHandlingArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionCountCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionCountCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("ihmvomoqruggodwn")
    public suspend
    fun insertHeaders(`value`: Output<List<WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("ukxmitkqncsslobf")
    public suspend fun insertHeaders(
        vararg
        values: Output<WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs>,
    ) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("akbkswaxgqvbxasr")
    public suspend
    fun insertHeaders(values: List<Output<WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("xvikgrfhejbpipig")
    public suspend
    fun insertHeaders(`value`: List<WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("gyivvuadxhcmiini")
    public suspend
    fun insertHeaders(argument: List<suspend WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("dotnwrgentahjkbp")
    public suspend fun insertHeaders(
        vararg
        argument: suspend WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("hcswwddvhfcgdeep")
    public suspend
    fun insertHeaders(argument: suspend WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("tjpgccqbixbohduc")
    public suspend fun insertHeaders(
        vararg
        values: WebAclRuleActionCountCustomRequestHandlingInsertHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): WebAclRuleActionCountCustomRequestHandlingArgs =
        WebAclRuleActionCountCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
