@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementIpSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the IP Set that this statement references.
 * @property ipSetForwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
 */
public data class WebAclRuleStatementIpSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val ipSetForwardedIpConfig:
    Output<WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementIpSetReferenceStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementIpSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementIpSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .ipSetForwardedIpConfig(
                ipSetForwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementIpSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementIpSetReferenceStatementArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var ipSetForwardedIpConfig:
        Output<WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("smogrfsmejtxvfjc")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
     */
    @JvmName("cspfnmyyljnpkafd")
    public suspend
    fun ipSetForwardedIpConfig(`value`: Output<WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>) {
        this.ipSetForwardedIpConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("fifhstiwnomboflu")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
     */
    @JvmName("vcsnlftwdrffdygb")
    public suspend
    fun ipSetForwardedIpConfig(`value`: WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetForwardedIpConfig = mapped
    }

    /**
     * @param argument Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
     */
    @JvmName("truetgphdkiajfmp")
    public suspend
    fun ipSetForwardedIpConfig(argument: suspend WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetForwardedIpConfig = mapped
    }

    internal fun build(): WebAclRuleStatementIpSetReferenceStatementArgs =
        WebAclRuleStatementIpSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            ipSetForwardedIpConfig = ipSetForwardedIpConfig,
        )
}
