@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property managedRuleGroupConfigs Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
 * @property name Name of the managed rule group.
 * @property ruleActionOverrides Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
 * @property scopeDownStatement Narrows the scope of the statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details.
 * @property vendorName Name of the managed rule group vendor.
 * @property version Version of the managed rule group. You can set `Version_1.0` or `Version_1.1` etc. If you want to use the default version, do not set anything.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementArgs(
    public val managedRuleGroupConfigs:
    Output<List<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs>>? = null,
    public val name: Output<String>,
    public val ruleActionOverrides:
    Output<List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs>>? = null,
    public val scopeDownStatement:
    Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs>? = null,
    public val vendorName: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementArgs.builder()
            .managedRuleGroupConfigs(
                managedRuleGroupConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .ruleActionOverrides(
                ruleActionOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scopeDownStatement(
                scopeDownStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vendorName(vendorName.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementArgsBuilder internal constructor() {
    private var managedRuleGroupConfigs:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs>>? = null

    private var name: Output<String>? = null

    private var ruleActionOverrides:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs>>? = null

    private var scopeDownStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs>? = null

    private var vendorName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("pkagxirjrcmfvarj")
    public suspend
    fun managedRuleGroupConfigs(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs>>) {
        this.managedRuleGroupConfigs = value
    }

    @JvmName("qlolxtokhuchmciy")
    public suspend fun managedRuleGroupConfigs(
        vararg
        values: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs>,
    ) {
        this.managedRuleGroupConfigs = Output.all(values.asList())
    }

    /**
     * @param values Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("eiibaqiyoloelddh")
    public suspend
    fun managedRuleGroupConfigs(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs>>) {
        this.managedRuleGroupConfigs = Output.all(values)
    }

    /**
     * @param value Name of the managed rule group.
     */
    @JvmName("vdxehoeryvjltjww")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("docpkghoopvlgbgv")
    public suspend
    fun ruleActionOverrides(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs>>) {
        this.ruleActionOverrides = value
    }

    @JvmName("klcqpkvaouonwepj")
    public suspend fun ruleActionOverrides(
        vararg
        values: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs>,
    ) {
        this.ruleActionOverrides = Output.all(values.asList())
    }

    /**
     * @param values Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("nsuwavuklctexsmv")
    public suspend
    fun ruleActionOverrides(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs>>) {
        this.ruleActionOverrides = Output.all(values)
    }

    /**
     * @param value Narrows the scope of the statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details.
     */
    @JvmName("kkvideqoxwrdobwr")
    public suspend
    fun scopeDownStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs>) {
        this.scopeDownStatement = value
    }

    /**
     * @param value Name of the managed rule group vendor.
     */
    @JvmName("qirbalafpmuvdnod")
    public suspend fun vendorName(`value`: Output<String>) {
        this.vendorName = value
    }

    /**
     * @param value Version of the managed rule group. You can set `Version_1.0` or `Version_1.1` etc. If you want to use the default version, do not set anything.
     */
    @JvmName("erwhkfetauegciib")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("edtwduehjryuqrol")
    public suspend
    fun managedRuleGroupConfigs(`value`: List<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRuleGroupConfigs = mapped
    }

    /**
     * @param argument Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("gwacxgnkgjicvwln")
    public suspend
    fun managedRuleGroupConfigs(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleGroupConfigs = mapped
    }

    /**
     * @param argument Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("gucgdsrqxnxymqqq")
    public suspend fun managedRuleGroupConfigs(
        vararg
        argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleGroupConfigs = mapped
    }

    /**
     * @param argument Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("hxvdlfdhxohpvimi")
    public suspend
    fun managedRuleGroupConfigs(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.managedRuleGroupConfigs = mapped
    }

    /**
     * @param values Additional information that's used by a managed rule group. Only one rule attribute is allowed in each config. See `managed_rule_group_configs` for more details
     */
    @JvmName("tlibwoiclpiaytck")
    public suspend fun managedRuleGroupConfigs(
        vararg
        values: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleGroupConfigs = mapped
    }

    /**
     * @param value Name of the managed rule group.
     */
    @JvmName("cadtxfjokhjlkodg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("holbkrkyegyatfpd")
    public suspend
    fun ruleActionOverrides(`value`: List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleActionOverrides = mapped
    }

    /**
     * @param argument Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("dmvkkgmislpwsbao")
    public suspend
    fun ruleActionOverrides(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleActionOverrides = mapped
    }

    /**
     * @param argument Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("qjowakssyxychcaq")
    public suspend fun ruleActionOverrides(
        vararg
        argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleActionOverrides = mapped
    }

    /**
     * @param argument Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("jiemsihmtjrmajml")
    public suspend
    fun ruleActionOverrides(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.ruleActionOverrides = mapped
    }

    /**
     * @param values Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("ieofpvbrpjlbpure")
    public suspend fun ruleActionOverrides(
        vararg
        values: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleActionOverrides = mapped
    }

    /**
     * @param value Narrows the scope of the statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details.
     */
    @JvmName("ietfcvdoifgprbti")
    public suspend
    fun scopeDownStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeDownStatement = mapped
    }

    /**
     * @param argument Narrows the scope of the statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details.
     */
    @JvmName("xngtcxwnevpnnyes")
    public suspend
    fun scopeDownStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scopeDownStatement = mapped
    }

    /**
     * @param value Name of the managed rule group vendor.
     */
    @JvmName("xpjjrvinkpkgdlht")
    public suspend fun vendorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vendorName = mapped
    }

    /**
     * @param value Version of the managed rule group. You can set `Version_1.0` or `Version_1.1` etc. If you want to use the default version, do not set anything.
     */
    @JvmName("tplpegroesmjvglh")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementArgs(
            managedRuleGroupConfigs = managedRuleGroupConfigs,
            name = name ?: throw PulumiNullFieldException("name"),
            ruleActionOverrides = ruleActionOverrides,
            scopeDownStatement = scopeDownStatement,
            vendorName = vendorName ?: throw PulumiNullFieldException("vendorName"),
            version = version,
        )
}
