@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property awsManagedRulesAcfpRuleSet Additional configuration for using the Account Creation Fraud Prevention managed rule group. Use this to specify information such as the registration page of your application and the type of content to accept or reject from the client.
 * @property awsManagedRulesAtpRuleSet Additional configuration for using the Account Takeover Protection managed rule group. Use this to specify information such as the sign-in page of your application and the type of content to accept or reject from the client.
 * @property awsManagedRulesBotControlRuleSet Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. See `aws_managed_rules_bot_control_rule_set` for more details
 * @property loginPath The path of the login endpoint for your application.
 * @property passwordField Details about your login page password field. See `password_field` for more details.
 * @property payloadType The payload type for your login endpoint, either JSON or form encoded.
 * @property usernameField Details about your login page username field. See `username_field` for more details.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs(
    public val awsManagedRulesAcfpRuleSet:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs>? =
        null,
    public val awsManagedRulesAtpRuleSet:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs>? =
        null,
    public val awsManagedRulesBotControlRuleSet:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs>? =
        null,
    public val loginPath: Output<String>? = null,
    public val passwordField:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordFieldArgs>? =
        null,
    public val payloadType: Output<String>? = null,
    public val usernameField:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameFieldArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs.builder()
            .awsManagedRulesAcfpRuleSet(
                awsManagedRulesAcfpRuleSet?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .awsManagedRulesAtpRuleSet(
                awsManagedRulesAtpRuleSet?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .awsManagedRulesBotControlRuleSet(
                awsManagedRulesBotControlRuleSet?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .loginPath(loginPath?.applyValue({ args0 -> args0 }))
            .passwordField(passwordField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .payloadType(payloadType?.applyValue({ args0 -> args0 }))
            .usernameField(usernameField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgsBuilder internal
constructor() {
    private var awsManagedRulesAcfpRuleSet:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs>? =
        null

    private var awsManagedRulesAtpRuleSet:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs>? =
        null

    private var awsManagedRulesBotControlRuleSet:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs>? =
        null

    private var loginPath: Output<String>? = null

    private var passwordField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordFieldArgs>? =
        null

    private var payloadType: Output<String>? = null

    private var usernameField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameFieldArgs>? =
        null

    /**
     * @param value Additional configuration for using the Account Creation Fraud Prevention managed rule group. Use this to specify information such as the registration page of your application and the type of content to accept or reject from the client.
     */
    @JvmName("grerwfiryxbkwexq")
    public suspend
    fun awsManagedRulesAcfpRuleSet(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs>) {
        this.awsManagedRulesAcfpRuleSet = value
    }

    /**
     * @param value Additional configuration for using the Account Takeover Protection managed rule group. Use this to specify information such as the sign-in page of your application and the type of content to accept or reject from the client.
     */
    @JvmName("gouqpggjtflrchdt")
    public suspend
    fun awsManagedRulesAtpRuleSet(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs>) {
        this.awsManagedRulesAtpRuleSet = value
    }

    /**
     * @param value Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. See `aws_managed_rules_bot_control_rule_set` for more details
     */
    @JvmName("oalmstoehhksmteq")
    public suspend
    fun awsManagedRulesBotControlRuleSet(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs>) {
        this.awsManagedRulesBotControlRuleSet = value
    }

    /**
     * @param value The path of the login endpoint for your application.
     */
    @JvmName("thqpmitiuewntavd")
    public suspend fun loginPath(`value`: Output<String>) {
        this.loginPath = value
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("qqcqyfumnlfjfdqm")
    public suspend
    fun passwordField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordFieldArgs>) {
        this.passwordField = value
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("wggolalxpwfsysnl")
    public suspend fun payloadType(`value`: Output<String>) {
        this.payloadType = value
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("vegjmgswgxpsnuaw")
    public suspend
    fun usernameField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameFieldArgs>) {
        this.usernameField = value
    }

    /**
     * @param value Additional configuration for using the Account Creation Fraud Prevention managed rule group. Use this to specify information such as the registration page of your application and the type of content to accept or reject from the client.
     */
    @JvmName("qpagdgqnyvximhhq")
    public suspend
    fun awsManagedRulesAcfpRuleSet(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsManagedRulesAcfpRuleSet = mapped
    }

    /**
     * @param argument Additional configuration for using the Account Creation Fraud Prevention managed rule group. Use this to specify information such as the registration page of your application and the type of content to accept or reject from the client.
     */
    @JvmName("uwmkymsqagbsttnd")
    public suspend
    fun awsManagedRulesAcfpRuleSet(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.awsManagedRulesAcfpRuleSet = mapped
    }

    /**
     * @param value Additional configuration for using the Account Takeover Protection managed rule group. Use this to specify information such as the sign-in page of your application and the type of content to accept or reject from the client.
     */
    @JvmName("xhixhlrghvkofgpd")
    public suspend
    fun awsManagedRulesAtpRuleSet(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsManagedRulesAtpRuleSet = mapped
    }

    /**
     * @param argument Additional configuration for using the Account Takeover Protection managed rule group. Use this to specify information such as the sign-in page of your application and the type of content to accept or reject from the client.
     */
    @JvmName("fygqoyqtfndugetg")
    public suspend
    fun awsManagedRulesAtpRuleSet(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.awsManagedRulesAtpRuleSet = mapped
    }

    /**
     * @param value Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. See `aws_managed_rules_bot_control_rule_set` for more details
     */
    @JvmName("yhhqfvbxtequjdev")
    public suspend
    fun awsManagedRulesBotControlRuleSet(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsManagedRulesBotControlRuleSet = mapped
    }

    /**
     * @param argument Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. See `aws_managed_rules_bot_control_rule_set` for more details
     */
    @JvmName("kidbuqsfolevmqfi")
    public suspend
    fun awsManagedRulesBotControlRuleSet(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.awsManagedRulesBotControlRuleSet = mapped
    }

    /**
     * @param value The path of the login endpoint for your application.
     */
    @JvmName("pbmalaciwddfrder")
    public suspend fun loginPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginPath = mapped
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("ogmhhpibgadhrgkl")
    public suspend
    fun passwordField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordField = mapped
    }

    /**
     * @param argument Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("yhnykkkgpwugxhux")
    public suspend
    fun passwordField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.passwordField = mapped
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("texiathmdvuuucod")
    public suspend fun payloadType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadType = mapped
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("shvaokmcaekujqbp")
    public suspend
    fun usernameField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameField = mapped
    }

    /**
     * @param argument Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("ywgrlbtnxwilwnol")
    public suspend
    fun usernameField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.usernameField = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigArgs(
            awsManagedRulesAcfpRuleSet = awsManagedRulesAcfpRuleSet,
            awsManagedRulesAtpRuleSet = awsManagedRulesAtpRuleSet,
            awsManagedRulesBotControlRuleSet = awsManagedRulesBotControlRuleSet,
            loginPath = loginPath,
            passwordField = passwordField,
            payloadType = payloadType,
            usernameField = usernameField,
        )
}
