@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property creationPath The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept POST requests.
 * @property enableRegexInPath Whether or not to allow the use of regular expressions in the login page path.
 * @property registrationPagePath The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users. This page must accept GET text/html requests.
 * @property requestInspection The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
 * @property responseInspection The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs(
    public val creationPath: Output<String>,
    public val enableRegexInPath: Output<Boolean>? = null,
    public val registrationPagePath: Output<String>,
    public val requestInspection:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs>,
    public val responseInspection:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs.builder()
            .creationPath(creationPath.applyValue({ args0 -> args0 }))
            .enableRegexInPath(enableRegexInPath?.applyValue({ args0 -> args0 }))
            .registrationPagePath(registrationPagePath.applyValue({ args0 -> args0 }))
            .requestInspection(requestInspection.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .responseInspection(
                responseInspection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgsBuilder
internal constructor() {
    private var creationPath: Output<String>? = null

    private var enableRegexInPath: Output<Boolean>? = null

    private var registrationPagePath: Output<String>? = null

    private var requestInspection:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs>? =
        null

    private var responseInspection:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionArgs>? =
        null

    /**
     * @param value The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept POST requests.
     */
    @JvmName("vjosyrpsdwxwoeyj")
    public suspend fun creationPath(`value`: Output<String>) {
        this.creationPath = value
    }

    /**
     * @param value Whether or not to allow the use of regular expressions in the login page path.
     */
    @JvmName("kxbrlspfvtggwiit")
    public suspend fun enableRegexInPath(`value`: Output<Boolean>) {
        this.enableRegexInPath = value
    }

    /**
     * @param value The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users. This page must accept GET text/html requests.
     */
    @JvmName("nqnphhxgehbxealb")
    public suspend fun registrationPagePath(`value`: Output<String>) {
        this.registrationPagePath = value
    }

    /**
     * @param value The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
     */
    @JvmName("kxusnmrkmwitudgi")
    public suspend
    fun requestInspection(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs>) {
        this.requestInspection = value
    }

    /**
     * @param value The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
     */
    @JvmName("lrrlcytrutjwprpl")
    public suspend
    fun responseInspection(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionArgs>) {
        this.responseInspection = value
    }

    /**
     * @param value The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept POST requests.
     */
    @JvmName("snknxfpfwyfjkbmb")
    public suspend fun creationPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.creationPath = mapped
    }

    /**
     * @param value Whether or not to allow the use of regular expressions in the login page path.
     */
    @JvmName("nryditfiuhydmlvp")
    public suspend fun enableRegexInPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRegexInPath = mapped
    }

    /**
     * @param value The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users. This page must accept GET text/html requests.
     */
    @JvmName("wcvlflhghlowcxgp")
    public suspend fun registrationPagePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registrationPagePath = mapped
    }

    /**
     * @param value The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
     */
    @JvmName("vhvsnuplttmcsrkt")
    public suspend
    fun requestInspection(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestInspection = mapped
    }

    /**
     * @param argument The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
     */
    @JvmName("lcwiitqqanvyltxt")
    public suspend
    fun requestInspection(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.requestInspection = mapped
    }

    /**
     * @param value The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
     */
    @JvmName("aecwjldlkxffbakh")
    public suspend
    fun responseInspection(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseInspection = mapped
    }

    /**
     * @param argument The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
     */
    @JvmName("ybhcqlyxepvjnjyx")
    public suspend
    fun responseInspection(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.responseInspection = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetArgs(
            creationPath = creationPath ?: throw PulumiNullFieldException("creationPath"),
            enableRegexInPath = enableRegexInPath,
            registrationPagePath = registrationPagePath ?: throw
                PulumiNullFieldException("registrationPagePath"),
            requestInspection = requestInspection ?: throw PulumiNullFieldException("requestInspection"),
            responseInspection = responseInspection,
        )
}
