@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property emailField
 * @property passwordField Details about your login page password field. See `password_field` for more details.
 * @property payloadType The payload type for your login endpoint, either JSON or form encoded.
 * @property usernameField Details about your login page username field. See `username_field` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs(
    public val emailField:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs>? =
        null,
    public val passwordField:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs>? =
        null,
    public val payloadType: Output<String>,
    public val usernameField:
    Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs.builder()
            .emailField(emailField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .passwordField(passwordField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .payloadType(payloadType.applyValue({ args0 -> args0 }))
            .usernameField(usernameField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgsBuilder
internal constructor() {
    private var emailField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs>? =
        null

    private var passwordField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs>? =
        null

    private var payloadType: Output<String>? = null

    private var usernameField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs>? =
        null

    /**
     * @param value
     */
    @JvmName("amcumvivgjdkmumh")
    public suspend
    fun emailField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs>) {
        this.emailField = value
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("tspsupdickrkxpfa")
    public suspend
    fun passwordField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs>) {
        this.passwordField = value
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("dijrxhbwqjudcwao")
    public suspend fun payloadType(`value`: Output<String>) {
        this.payloadType = value
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("gveekufxwudwfulb")
    public suspend
    fun usernameField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs>) {
        this.usernameField = value
    }

    /**
     * @param value
     */
    @JvmName("snxsnvnfpiwoheta")
    public suspend
    fun emailField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailField = mapped
    }

    /**
     * @param argument
     */
    @JvmName("caxelpggpcarbmap")
    public suspend
    fun emailField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.emailField = mapped
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("xqneeqtrnkykfmex")
    public suspend
    fun passwordField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordField = mapped
    }

    /**
     * @param argument Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("jomdxxnwjivlfhsj")
    public suspend
    fun passwordField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.passwordField = mapped
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("bbfppkhkcvfthhnm")
    public suspend fun payloadType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.payloadType = mapped
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("pmjeyrsouivwugpy")
    public suspend
    fun usernameField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameField = mapped
    }

    /**
     * @param argument Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("itddxbgmncjoojgj")
    public suspend
    fun usernameField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.usernameField = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs(
            emailField = emailField,
            passwordField = passwordField,
            payloadType = payloadType ?: throw PulumiNullFieldException("payloadType"),
            usernameField = usernameField,
        )
}
