@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureValues Values in the response header with the specified name that indicate a failed login attempt.
 * @property identifier The identifier for the value to match against in the JSON.
 * @property successValues Values in the response header with the specified name that indicate a successful login attempt.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs(
    public val failureValues: Output<List<String>>,
    public val identifier: Output<String>,
    public val successValues: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs.builder()
            .failureValues(failureValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .identifier(identifier.applyValue({ args0 -> args0 }))
            .successValues(successValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgsBuilder
internal constructor() {
    private var failureValues: Output<List<String>>? = null

    private var identifier: Output<String>? = null

    private var successValues: Output<List<String>>? = null

    /**
     * @param value Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("pjrougglmqwjptlt")
    public suspend fun failureValues(`value`: Output<List<String>>) {
        this.failureValues = value
    }

    @JvmName("saghvinruggbnnoc")
    public suspend fun failureValues(vararg values: Output<String>) {
        this.failureValues = Output.all(values.asList())
    }

    /**
     * @param values Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("choptnyopxcgybkc")
    public suspend fun failureValues(values: List<Output<String>>) {
        this.failureValues = Output.all(values)
    }

    /**
     * @param value The identifier for the value to match against in the JSON.
     */
    @JvmName("cxkcpioccwiketkw")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("dhsrvcnbfkrieibm")
    public suspend fun successValues(`value`: Output<List<String>>) {
        this.successValues = value
    }

    @JvmName("eqmjrmkxfipbpiis")
    public suspend fun successValues(vararg values: Output<String>) {
        this.successValues = Output.all(values.asList())
    }

    /**
     * @param values Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("rmuijfkkqfsxlvdc")
    public suspend fun successValues(values: List<Output<String>>) {
        this.successValues = Output.all(values)
    }

    /**
     * @param value Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("vkokbkklesxdlyvo")
    public suspend fun failureValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureValues = mapped
    }

    /**
     * @param values Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("uniuuyfcfwjojyky")
    public suspend fun failureValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureValues = mapped
    }

    /**
     * @param value The identifier for the value to match against in the JSON.
     */
    @JvmName("gqbvbmjghovhdami")
    public suspend fun identifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("bqwdmrinmxhbnyis")
    public suspend fun successValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successValues = mapped
    }

    /**
     * @param values Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("ikbdlehtnqxctvkr")
    public suspend fun successValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successValues = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionJsonArgs(
            failureValues = failureValues ?: throw PulumiNullFieldException("failureValues"),
            identifier = identifier ?: throw PulumiNullFieldException("identifier"),
            successValues = successValues ?: throw PulumiNullFieldException("successValues"),
        )
}
