@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureCodes Status codes in the response that indicate a failed login attempt.
 * @property successCodes Status codes in the response that indicate a successful login attempt.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs(
    public val failureCodes: Output<List<Int>>,
    public val successCodes: Output<List<Int>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs.builder()
            .failureCodes(failureCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .successCodes(successCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgsBuilder
internal constructor() {
    private var failureCodes: Output<List<Int>>? = null

    private var successCodes: Output<List<Int>>? = null

    /**
     * @param value Status codes in the response that indicate a failed login attempt.
     */
    @JvmName("fjvkhfgpsscfdsdf")
    public suspend fun failureCodes(`value`: Output<List<Int>>) {
        this.failureCodes = value
    }

    @JvmName("apneddtxugamjbqf")
    public suspend fun failureCodes(vararg values: Output<Int>) {
        this.failureCodes = Output.all(values.asList())
    }

    /**
     * @param values Status codes in the response that indicate a failed login attempt.
     */
    @JvmName("lllcltecvxppgfyq")
    public suspend fun failureCodes(values: List<Output<Int>>) {
        this.failureCodes = Output.all(values)
    }

    /**
     * @param value Status codes in the response that indicate a successful login attempt.
     */
    @JvmName("ycaiahygmrtenxnm")
    public suspend fun successCodes(`value`: Output<List<Int>>) {
        this.successCodes = value
    }

    @JvmName("qmbouvapuxfsylro")
    public suspend fun successCodes(vararg values: Output<Int>) {
        this.successCodes = Output.all(values.asList())
    }

    /**
     * @param values Status codes in the response that indicate a successful login attempt.
     */
    @JvmName("qfjdxqbscgvyqqfk")
    public suspend fun successCodes(values: List<Output<Int>>) {
        this.successCodes = Output.all(values)
    }

    /**
     * @param value Status codes in the response that indicate a failed login attempt.
     */
    @JvmName("rdsseieldkensyyb")
    public suspend fun failureCodes(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureCodes = mapped
    }

    /**
     * @param values Status codes in the response that indicate a failed login attempt.
     */
    @JvmName("qohaohbxpgaotmyg")
    public suspend fun failureCodes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureCodes = mapped
    }

    /**
     * @param value Status codes in the response that indicate a successful login attempt.
     */
    @JvmName("wpktmatittrfeapy")
    public suspend fun successCodes(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successCodes = mapped
    }

    /**
     * @param values Status codes in the response that indicate a successful login attempt.
     */
    @JvmName("jenysgjnvdcaoelt")
    public suspend fun successCodes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successCodes = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionStatusCodeArgs(
            failureCodes = failureCodes ?: throw PulumiNullFieldException("failureCodes"),
            successCodes = successCodes ?: throw PulumiNullFieldException("successCodes"),
        )
}
