@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allow Instructs AWS WAF to allow the web request. See `allow` below for details.
 * @property block Instructs AWS WAF to block the web request. See `block` below for details.
 * @property captcha Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
 * @property challenge Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
 * @property count Instructs AWS WAF to count the web request and allow it. See `count` below for details.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs(
    public val allow:
    Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseAllowArgs>? =
        null,
    public val block:
    Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockArgs>? =
        null,
    public val captcha:
    Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCaptchaArgs>? =
        null,
    public val challenge:
    Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseChallengeArgs>? =
        null,
    public val count:
    Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCountArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .block(block?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captcha(captcha?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .challenge(challenge?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .count(count?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgsBuilder
internal constructor() {
    private var allow:
        Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseAllowArgs>? =
        null

    private var block:
        Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockArgs>? =
        null

    private var captcha:
        Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCaptchaArgs>? =
        null

    private var challenge:
        Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseChallengeArgs>? =
        null

    private var count:
        Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCountArgs>? =
        null

    /**
     * @param value Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("fepkdeasdbagdeqf")
    public suspend
    fun allow(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseAllowArgs>) {
        this.allow = value
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("ahaioxhtllqceiyh")
    public suspend
    fun block(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockArgs>) {
        this.block = value
    }

    /**
     * @param value Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("vagunmwkmgqifmyq")
    public suspend
    fun captcha(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCaptchaArgs>) {
        this.captcha = value
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("gbhmaiglldtmxhns")
    public suspend
    fun challenge(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseChallengeArgs>) {
        this.challenge = value
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("duriqurifgtpillb")
    public suspend
    fun count(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCountArgs>) {
        this.count = value
    }

    /**
     * @param value Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("vknhyhecdbeyqfwl")
    public suspend
    fun allow(`value`: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseAllowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param argument Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("ftgmkdhsiotbrwmh")
    public suspend
    fun allow(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseAllowArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseAllowArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("ldgnxwmmhgjdhnmw")
    public suspend
    fun block(`value`: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.block = mapped
    }

    /**
     * @param argument Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("avirirnmvqpcsjnk")
    public suspend
    fun block(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.block = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("fgstnaijwjkwhxnj")
    public suspend
    fun captcha(`value`: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCaptchaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captcha = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("gujdqxscsbamkbqr")
    public suspend
    fun captcha(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCaptchaArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCaptchaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.captcha = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("dvgrsxgxtdcddmhx")
    public suspend
    fun challenge(`value`: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseChallengeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.challenge = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("ajxjckuumlshulol")
    public suspend
    fun challenge(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseChallengeArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseChallengeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.challenge = mapped
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("cjvkltixsglociar")
    public suspend
    fun count(`value`: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param argument Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("ewxcrnriekuwmeqq")
    public suspend
    fun count(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.count = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs =
        WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs(
            allow = allow,
            block = block,
            captcha = captcha,
            challenge = challenge,
            count = count,
        )
}
