@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property statements The statements to combine.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs(
    public val statements: Output<List<WebAclRuleStatementArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs.builder()
            .statements(
                statements.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgsBuilder
internal constructor() {
    private var statements: Output<List<WebAclRuleStatementArgs>>? = null

    /**
     * @param value The statements to combine.
     */
    @JvmName("juluoodgmdblnsnh")
    public suspend fun statements(`value`: Output<List<WebAclRuleStatementArgs>>) {
        this.statements = value
    }

    @JvmName("dwfchckfpufvgpbv")
    public suspend fun statements(vararg values: Output<WebAclRuleStatementArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("eawyqvjcxcsbmwbx")
    public suspend fun statements(values: List<Output<WebAclRuleStatementArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value The statements to combine.
     */
    @JvmName("qwisdwiobltbpcpg")
    public suspend fun statements(`value`: List<WebAclRuleStatementArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("eqedjqhigailtcwd")
    public suspend fun statements(argument: List<suspend WebAclRuleStatementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("mqubguujmqmeqwpp")
    public suspend fun statements(
        vararg
        argument: suspend WebAclRuleStatementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("dpsxybaxxwehhclq")
    public suspend fun statements(argument: suspend WebAclRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleStatementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("umeulhtadodagvpl")
    public suspend fun statements(vararg values: WebAclRuleStatementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs(
            statements = statements ?: throw PulumiNullFieldException("statements"),
        )
}
