@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property all An empty configuration block that is used for inspecting all headers.
 * @property excludedHeaders An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
 * @property includedHeaders An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs(
    public val all:
    Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? =
        null,
    public val excludedHeaders: Output<List<String>>? = null,
    public val includedHeaders: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs.builder()
            .all(all?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .excludedHeaders(excludedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedHeaders(includedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgsBuilder
internal constructor() {
    private var all:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? =
        null

    private var excludedHeaders: Output<List<String>>? = null

    private var includedHeaders: Output<List<String>>? = null

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("nasmeocnvpewxkdg")
    public suspend
    fun all(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs>) {
        this.all = value
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("vixcpvqoxpjycful")
    public suspend fun excludedHeaders(`value`: Output<List<String>>) {
        this.excludedHeaders = value
    }

    @JvmName("lpljsgijojmchiuk")
    public suspend fun excludedHeaders(vararg values: Output<String>) {
        this.excludedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("cyqaiqovqtavqnja")
    public suspend fun excludedHeaders(values: List<Output<String>>) {
        this.excludedHeaders = Output.all(values)
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("vancvxdfeudqjpdo")
    public suspend fun includedHeaders(`value`: Output<List<String>>) {
        this.includedHeaders = value
    }

    @JvmName("hjrktoqcxyoygsta")
    public suspend fun includedHeaders(vararg values: Output<String>) {
        this.includedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("pvcnstpkdslbocxu")
    public suspend fun includedHeaders(values: List<Output<String>>) {
        this.includedHeaders = Output.all(values)
    }

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("ofpaoqwmdeijacpo")
    public suspend
    fun all(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.all = mapped
    }

    /**
     * @param argument An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("lelbxxufhxhqgejt")
    public suspend
    fun all(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.all = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("ixrdboeboxwgftfu")
    public suspend fun excludedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("yhppabakgagbuegd")
    public suspend fun excludedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("oclejeekniwslaps")
    public suspend fun includedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("mtqojudmhyvqkmkn")
    public suspend fun includedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs(
            all = all,
            excludedHeaders = excludedHeaders,
            includedHeaders = includedHeaders,
        )
}
