@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the IP Set that this statement references.
 * @property ipSetForwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val ipSetForwardedIpConfig:
    Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .ipSetForwardedIpConfig(
                ipSetForwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgsBuilder
internal constructor() {
    private var arn: Output<String>? = null

    private var ipSetForwardedIpConfig:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("qyjwcrkdrdnphxgt")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
     */
    @JvmName("hkokssljcpjpideo")
    public suspend
    fun ipSetForwardedIpConfig(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>) {
        this.ipSetForwardedIpConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("syedqhgrcfivnjkr")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
     */
    @JvmName("dxlvpfmucfatpamb")
    public suspend
    fun ipSetForwardedIpConfig(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetForwardedIpConfig = mapped
    }

    /**
     * @param argument Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
     */
    @JvmName("kxjdmogrigidthej")
    public suspend
    fun ipSetForwardedIpConfig(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetForwardedIpConfig = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            ipSetForwardedIpConfig = ipSetForwardedIpConfig,
        )
}
