@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fallbackBehavior Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
 * @property headerName Name of the HTTP header to use for the IP address.
 * @property position Position in the header to search for the IP address. Valid values include: `FIRST`, `LAST`, or `ANY`. If `ANY` is specified and the header contains more than 10 IP addresses, AWS WAFv2 inspects the last 10.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs(
    public val fallbackBehavior: Output<String>,
    public val headerName: Output<String>,
    public val position: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs.builder()
            .fallbackBehavior(fallbackBehavior.applyValue({ args0 -> args0 }))
            .headerName(headerName.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder
internal constructor() {
    private var fallbackBehavior: Output<String>? = null

    private var headerName: Output<String>? = null

    private var position: Output<String>? = null

    /**
     * @param value Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("yffdvsfvoaqfmhjj")
    public suspend fun fallbackBehavior(`value`: Output<String>) {
        this.fallbackBehavior = value
    }

    /**
     * @param value Name of the HTTP header to use for the IP address.
     */
    @JvmName("fprdtjgtlerlybot")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value Position in the header to search for the IP address. Valid values include: `FIRST`, `LAST`, or `ANY`. If `ANY` is specified and the header contains more than 10 IP addresses, AWS WAFv2 inspects the last 10.
     */
    @JvmName("nvihqvbvhnjfdccg")
    public suspend fun position(`value`: Output<String>) {
        this.position = value
    }

    /**
     * @param value Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("fbrtnvvrhxhvybos")
    public suspend fun fallbackBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fallbackBehavior = mapped
    }

    /**
     * @param value Name of the HTTP header to use for the IP address.
     */
    @JvmName("xxhrnvudxloqvfcl")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    /**
     * @param value Position in the header to search for the IP address. Valid values include: `FIRST`, `LAST`, or `ANY`. If `ANY` is specified and the header contains more than 10 IP addresses, AWS WAFv2 inspects the last 10.
     */
    @JvmName("csjklkwiaprghxrl")
    public suspend fun position(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs(
            fallbackBehavior = fallbackBehavior ?: throw PulumiNullFieldException("fallbackBehavior"),
            headerName = headerName ?: throw PulumiNullFieldException("headerName"),
            position = position ?: throw PulumiNullFieldException("position"),
        )
}
