@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key String to match against.
 * @property scope Specify whether you want to match using the label name or just the namespace. Valid values are `LABEL` or `NAMESPACE`.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs(
    public val key: Output<String>,
    public val scope: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .scope(scope.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgsBuilder
internal constructor() {
    private var key: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value String to match against.
     */
    @JvmName("brhuscwujlcyisdn")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Specify whether you want to match using the label name or just the namespace. Valid values are `LABEL` or `NAMESPACE`.
     */
    @JvmName("lqecaxtbvgvormej")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value String to match against.
     */
    @JvmName("hfnnniqsgywrlqba")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Specify whether you want to match using the label name or just the namespace. Valid values are `LABEL` or `NAMESPACE`.
     */
    @JvmName("wnhkjoovtelmfnpa")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build():
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            scope = scope ?: throw PulumiNullFieldException("scope"),
        )
}
