@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property aggregateKeyType Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP`, or `IP`. Default: `IP`.
 * @property customKeys Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
 * @property forwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See `forwarded_ip_config` below for details.
 * @property limit Limit on requests per 5-minute period for a single originating IP address.
 * @property scopeDownStatement Optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
 */
public data class WebAclRuleStatementRateBasedStatementArgs(
    public val aggregateKeyType: Output<String>? = null,
    public val customKeys: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyArgs>>? = null,
    public val forwardedIpConfig: Output<WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs>? =
        null,
    public val limit: Output<Int>,
    public val scopeDownStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementArgs.builder()
            .aggregateKeyType(aggregateKeyType?.applyValue({ args0 -> args0 }))
            .customKeys(
                customKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .forwardedIpConfig(forwardedIpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .limit(limit.applyValue({ args0 -> args0 }))
            .scopeDownStatement(
                scopeDownStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementArgsBuilder internal constructor() {
    private var aggregateKeyType: Output<String>? = null

    private var customKeys: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyArgs>>? = null

    private var forwardedIpConfig: Output<WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs>? =
        null

    private var limit: Output<Int>? = null

    private var scopeDownStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementArgs>? = null

    /**
     * @param value Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP`, or `IP`. Default: `IP`.
     */
    @JvmName("leslfvnlkgrfhile")
    public suspend fun aggregateKeyType(`value`: Output<String>) {
        this.aggregateKeyType = value
    }

    /**
     * @param value Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("jdtnjyajbamgfjru")
    public suspend
    fun customKeys(`value`: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyArgs>>) {
        this.customKeys = value
    }

    @JvmName("nqujiawlmpmbdyrv")
    public suspend fun customKeys(
        vararg
        values: Output<WebAclRuleStatementRateBasedStatementCustomKeyArgs>,
    ) {
        this.customKeys = Output.all(values.asList())
    }

    /**
     * @param values Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("thyfelofpyuqjhyc")
    public suspend
    fun customKeys(values: List<Output<WebAclRuleStatementRateBasedStatementCustomKeyArgs>>) {
        this.customKeys = Output.all(values)
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See `forwarded_ip_config` below for details.
     */
    @JvmName("jspedxooiajmunrf")
    public suspend
    fun forwardedIpConfig(`value`: Output<WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs>) {
        this.forwardedIpConfig = value
    }

    /**
     * @param value Limit on requests per 5-minute period for a single originating IP address.
     */
    @JvmName("norelrovamquupqb")
    public suspend fun limit(`value`: Output<Int>) {
        this.limit = value
    }

    /**
     * @param value Optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
     */
    @JvmName("olgwvbyqdepduaml")
    public suspend
    fun scopeDownStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementArgs>) {
        this.scopeDownStatement = value
    }

    /**
     * @param value Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP`, or `IP`. Default: `IP`.
     */
    @JvmName("uduskjqfwhoiuxkl")
    public suspend fun aggregateKeyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregateKeyType = mapped
    }

    /**
     * @param value Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("dgvdvdgllmdsodfp")
    public suspend
    fun customKeys(`value`: List<WebAclRuleStatementRateBasedStatementCustomKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeys = mapped
    }

    /**
     * @param argument Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("dpuybruukyauapbr")
    public suspend
    fun customKeys(argument: List<suspend WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customKeys = mapped
    }

    /**
     * @param argument Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("pmadqxmutupicadn")
    public suspend fun customKeys(
        vararg
        argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customKeys = mapped
    }

    /**
     * @param argument Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("cqjbjdlgmbysvqpb")
    public suspend
    fun customKeys(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.customKeys = mapped
    }

    /**
     * @param values Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("ygdrilkmsigiueew")
    public suspend fun customKeys(vararg values: WebAclRuleStatementRateBasedStatementCustomKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customKeys = mapped
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See `forwarded_ip_config` below for details.
     */
    @JvmName("jyisjvgfwuytnobe")
    public suspend
    fun forwardedIpConfig(`value`: WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIpConfig = mapped
    }

    /**
     * @param argument Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See `forwarded_ip_config` below for details.
     */
    @JvmName("ehbbvnrwrnwbbwwj")
    public suspend
    fun forwardedIpConfig(argument: suspend WebAclRuleStatementRateBasedStatementForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIpConfig = mapped
    }

    /**
     * @param value Limit on requests per 5-minute period for a single originating IP address.
     */
    @JvmName("vqafrkjxjgjyagnc")
    public suspend fun limit(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    /**
     * @param value Optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
     */
    @JvmName("ujtljvlofvqwwvsp")
    public suspend
    fun scopeDownStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeDownStatement = mapped
    }

    /**
     * @param argument Optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See `statement` above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
     */
    @JvmName("xllqktqsigepkqym")
    public suspend
    fun scopeDownStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scopeDownStatement = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementArgs =
        WebAclRuleStatementRateBasedStatementArgs(
            aggregateKeyType = aggregateKeyType,
            customKeys = customKeys,
            forwardedIpConfig = forwardedIpConfig,
            limit = limit ?: throw PulumiNullFieldException("limit"),
            scopeDownStatement = scopeDownStatement,
        )
}
