@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the cookie to use.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs(
    public val name: Output<String>,
    public val textTransformations:
    Output<List<WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyCookieArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>? =
        null

    /**
     * @param value The name of the cookie to use.
     */
    @JvmName("kdkeqjhxawsyfgje")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("dbaesrwfwpumnwec")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("wiowhekgjriomcnh")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("ixheunsdirqgrmfv")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The name of the cookie to use.
     */
    @JvmName("lwatuhlpnlboajkg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("dsncmyleusmuyykb")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("bcpqreebvegigmns")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("gvprhbmxqnrganib")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("apomhqnuqhegvqrv")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("bsrlrtxhmfyaixbj")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
