@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the header to use.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs(
    public val name: Output<String>,
    public val textTransformations:
    Output<List<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>? =
        null

    /**
     * @param value The name of the header to use.
     */
    @JvmName("ueqabngitufepwth")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("nexluremxoxdvgig")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("qbnmwtbsdkfbyeqd")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("kopulfbyiyjeokph")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The name of the header to use.
     */
    @JvmName("pjngokshergsdspr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("tgujjhiroaejiphr")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("yfwgjacpyxaluwhu")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("arbhsmicthccbjqa")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("qxvwcssoqdmkmoga")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("flgnyuebgkgqbpjw")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
