@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespace The namespace to use for aggregation
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs(
    public val namespace: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs.builder()
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgsBuilder internal
constructor() {
    private var namespace: Output<String>? = null

    /**
     * @param value The namespace to use for aggregation
     */
    @JvmName("wyapwiolilrrlxla")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The namespace to use for aggregation
     */
    @JvmName("bdhtmwpemxsfcmxe")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs(
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        )
}
