@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs(
    public val textTransformations:
    Output<List<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs.builder()
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgsBuilder internal
constructor() {
    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>? =
        null

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("ruwyfbqyfgallaqn")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("gopsbwjcjujpwfhr")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("ctywjmbavevcvnkg")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("jkwhgjowrkjtifdl")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("wdnnmycmjjkactgp")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("dndmqyhnsllxrdfi")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("wxsavxmsnvmjmrlt")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("jrshdjrkhachvdxi")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs(
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
