@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs(
    public val textTransformations:
    Output<List<WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs.builder()
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgsBuilder internal constructor() {
    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>? =
        null

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("nfnydkmpbhvwkfmn")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("hxjqocxhawpulhvl")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("hrvxviahxjwsjxgj")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("mfflpyremylqoyed")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("sfhwsfqvaqqhbaqa")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("mvyvqtapqbvednan")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("xrsjwhqahkicxtiy")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("pfmhqtmtpukldnwy")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs(
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
