@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property andStatement Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
 * @property byteMatchStatement Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
 * @property geoMatchStatement Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
 * @property ipSetReferenceStatement Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
 * @property labelMatchStatement Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
 * @property notStatement Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
 * @property orStatement Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
 * @property regexMatchStatement Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
 * @property regexPatternSetReferenceStatement Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
 * @property sizeConstraintStatement Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
 * @property xssMatchStatement Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementScopeDownStatementArgs(
    public val andStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs>? = null,
    public val byteMatchStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs>? = null,
    public val geoMatchStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs>? = null,
    public val ipSetReferenceStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs>? =
        null,
    public val labelMatchStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs>? =
        null,
    public val notStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs>? = null,
    public val orStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs>? = null,
    public val regexMatchStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs>? =
        null,
    public val regexPatternSetReferenceStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>? =
        null,
    public val sizeConstraintStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs>? =
        null,
    public val sqliMatchStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs>? = null,
    public val xssMatchStatement:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementArgs.builder()
            .andStatement(andStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .byteMatchStatement(
                byteMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .geoMatchStatement(geoMatchStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipSetReferenceStatement(
                ipSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labelMatchStatement(
                labelMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notStatement(notStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orStatement(orStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexMatchStatement(
                regexMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexPatternSetReferenceStatement(
                regexPatternSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sizeConstraintStatement(
                sizeConstraintStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqliMatchStatement(
                sqliMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .xssMatchStatement(
                xssMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementScopeDownStatementArgsBuilder internal
constructor() {
    private var andStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs>? = null

    private var byteMatchStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs>? = null

    private var geoMatchStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs>? = null

    private var ipSetReferenceStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs>? =
        null

    private var labelMatchStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs>? = null

    private var notStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs>? = null

    private var orStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs>? = null

    private var regexMatchStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs>? = null

    private var regexPatternSetReferenceStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>? =
        null

    private var sizeConstraintStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs>? =
        null

    private var sqliMatchStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs>? = null

    private var xssMatchStatement:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs>? = null

    /**
     * @param value Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("snhvxuovyubnkpkf")
    public suspend
    fun andStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs>) {
        this.andStatement = value
    }

    /**
     * @param value Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("wxcnuxisgryumqhq")
    public suspend
    fun byteMatchStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs>) {
        this.byteMatchStatement = value
    }

    /**
     * @param value Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("rpruhxfqeefxxnbv")
    public suspend
    fun geoMatchStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs>) {
        this.geoMatchStatement = value
    }

    /**
     * @param value Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("qudsyucirlvvnqdu")
    public suspend
    fun ipSetReferenceStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs>) {
        this.ipSetReferenceStatement = value
    }

    /**
     * @param value Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("lgwvfhulorgelxql")
    public suspend
    fun labelMatchStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs>) {
        this.labelMatchStatement = value
    }

    /**
     * @param value Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("ctknxgkrfhqfeyvg")
    public suspend
    fun notStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs>) {
        this.notStatement = value
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("rgcbsaaqnlmvtvih")
    public suspend
    fun orStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs>) {
        this.orStatement = value
    }

    /**
     * @param value Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("wybidarjucpbrnms")
    public suspend
    fun regexMatchStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs>) {
        this.regexMatchStatement = value
    }

    /**
     * @param value Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("tadurlpamlfanamx")
    public suspend
    fun regexPatternSetReferenceStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>) {
        this.regexPatternSetReferenceStatement = value
    }

    /**
     * @param value Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("ivmffjmiaxclebaj")
    public suspend
    fun sizeConstraintStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs>) {
        this.sizeConstraintStatement = value
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("ccfjpitnerueyjjm")
    public suspend
    fun sqliMatchStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs>) {
        this.sqliMatchStatement = value
    }

    /**
     * @param value Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("qtaciybkcrcsnced")
    public suspend
    fun xssMatchStatement(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs>) {
        this.xssMatchStatement = value
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("lndrktaxaoldjgkr")
    public suspend
    fun andStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.andStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("sqmlqamhtwgkcuge")
    public suspend
    fun andStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.andStatement = mapped
    }

    /**
     * @param value Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("yfadvknlvesjkhgt")
    public suspend
    fun byteMatchStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("hbhvabgvkyapvesq")
    public suspend
    fun byteMatchStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.byteMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("mevrvandgqyisycr")
    public suspend
    fun geoMatchStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMatchStatement = mapped
    }

    /**
     * @param argument Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("ildubqjlevxjboyw")
    public suspend
    fun geoMatchStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.geoMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("mcnrtfqqojectxmi")
    public suspend
    fun ipSetReferenceStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("unfcorhmnggkaond")
    public suspend
    fun ipSetReferenceStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param value Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("xgbtdkthlqlnwsbq")
    public suspend
    fun labelMatchStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("gtlcbdnuegwiohnf")
    public suspend
    fun labelMatchStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.labelMatchStatement = mapped
    }

    /**
     * @param value Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("llxkrcfthfkqefdx")
    public suspend
    fun notStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("hoekiiddvuokwdhk")
    public suspend
    fun notStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.notStatement = mapped
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("diafjdjijjxxaoqb")
    public suspend
    fun orStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("axssjtmbdiykijrx")
    public suspend
    fun orStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.orStatement = mapped
    }

    /**
     * @param value Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("vwandnhvxkqhxudc")
    public suspend
    fun regexMatchStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchStatement = mapped
    }

    /**
     * @param argument Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("gydyepdapiremhlm")
    public suspend
    fun regexMatchStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("kjchqjigonkpjbwy")
    public suspend
    fun regexPatternSetReferenceStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("kakuajoponumqwnj")
    public suspend
    fun regexPatternSetReferenceStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param value Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("rrfmxmwiumrhkbpp")
    public suspend
    fun sizeConstraintStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param argument Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("wcatjgcvobedwcir")
    public suspend
    fun sizeConstraintStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("evrtvnsfmbfghuqe")
    public suspend
    fun sqliMatchStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqliMatchStatement = mapped
    }

    /**
     * @param argument An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("vkmevhnieipsmcbx")
    public suspend
    fun sqliMatchStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sqliMatchStatement = mapped
    }

    /**
     * @param value Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("ffwcspldxosjpvwn")
    public suspend
    fun xssMatchStatement(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("ynmabyvuufxusnfg")
    public suspend
    fun xssMatchStatement(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.xssMatchStatement = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementScopeDownStatementArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementArgs(
            andStatement = andStatement,
            byteMatchStatement = byteMatchStatement,
            geoMatchStatement = geoMatchStatement,
            ipSetReferenceStatement = ipSetReferenceStatement,
            labelMatchStatement = labelMatchStatement,
            notStatement = notStatement,
            orStatement = orStatement,
            regexMatchStatement = regexMatchStatement,
            regexPatternSetReferenceStatement = regexPatternSetReferenceStatement,
            sizeConstraintStatement = sizeConstraintStatement,
            sqliMatchStatement = sqliMatchStatement,
            xssMatchStatement = xssMatchStatement,
        )
}
