@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property positionalConstraint Area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
 * @property searchString String value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs(
    public val fieldToMatch:
    Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs>? =
        null,
    public val positionalConstraint: Output<String>,
    public val searchString: Output<String>,
    public val textTransformations:
    Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .positionalConstraint(positionalConstraint.applyValue({ args0 -> args0 }))
            .searchString(searchString.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgsBuilder
internal constructor() {
    private var fieldToMatch:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs>? =
        null

    private var positionalConstraint: Output<String>? = null

    private var searchString: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs>>? =
        null

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("xifjvjkrgtbqyhyy")
    public suspend
    fun fieldToMatch(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
     */
    @JvmName("uowbwnrijupnasim")
    public suspend fun positionalConstraint(`value`: Output<String>) {
        this.positionalConstraint = value
    }

    /**
     * @param value String value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
     */
    @JvmName("juahtofahhppoyad")
    public suspend fun searchString(`value`: Output<String>) {
        this.searchString = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("lvimpbtpamofybjp")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("vmgihcnuanmwsldk")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("jftakwoqjfpomyjg")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("elnvnbiapggwmugr")
    public suspend
    fun fieldToMatch(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("wdaikyfeqvxbtkah")
    public suspend
    fun fieldToMatch(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
     */
    @JvmName("qnadbfpdheyohkub")
    public suspend fun positionalConstraint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.positionalConstraint = mapped
    }

    /**
     * @param value String value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
     */
    @JvmName("jfkitutaxibjwwno")
    public suspend fun searchString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchString = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("gqqhyjbjntmmcvpq")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ddxtxojlowwvxxvk")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("krokfhxdcmgihvmf")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("doowiwnxdwayaklg")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("xhdcflbfvwuljret")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build():
        WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            positionalConstraint = positionalConstraint ?: throw
                PulumiNullFieldException("positionalConstraint"),
            searchString = searchString ?: throw PulumiNullFieldException("searchString"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
