@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property regexString String representing the regular expression. Minimum of `1` and maximum of `512` characters.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementRegexMatchStatementArgs(
    public val fieldToMatch: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchArgs>? = null,
    public val regexString: Output<String>,
    public val textTransformations:
    Output<List<WebAclRuleStatementRegexMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexString(regexString.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRegexMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRegexMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchArgs>? = null

    private var regexString: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRegexMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("lfmwbksbxkvrgjhe")
    public suspend
    fun fieldToMatch(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value String representing the regular expression. Minimum of `1` and maximum of `512` characters.
     */
    @JvmName("itcdclutytqdlasf")
    public suspend fun regexString(`value`: Output<String>) {
        this.regexString = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("kjasslhqnowvprbw")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementRegexMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("uwgwqxqgynsutwrf")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementRegexMatchStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("bkuicfinbipiaewt")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementRegexMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("xvujtwdpocpekhbm")
    public suspend
    fun fieldToMatch(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("ubxwgwiufuubdcqa")
    public suspend
    fun fieldToMatch(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRegexMatchStatementFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value String representing the regular expression. Minimum of `1` and maximum of `512` characters.
     */
    @JvmName("uytbksqpuctvbapx")
    public suspend fun regexString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexString = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("pacuvgnpppwiynfy")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementRegexMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("tmwflwdxpohmyucc")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("jciqhxyswwrcmtun")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("hqnjvnvhmpdvrrio")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("fgrxtgmyobblepoq")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementRegexMatchStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRegexMatchStatementArgs =
        WebAclRuleStatementRegexMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            regexString = regexString ?: throw PulumiNullFieldException("regexString"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
