@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementRegexMatchStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<WebAclRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchCookiesArgs>? = null,
    public val headers: Output<List<WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<WebAclRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchMethodArgs>? = null,
    public val queryString: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader:
    Output<WebAclRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument:
    Output<WebAclRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchUriPathArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementRegexMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRegexMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchCookiesArgs>? = null

    private var headers: Output<List<WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchMethodArgs>? = null

    private var queryString:
        Output<WebAclRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<WebAclRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<WebAclRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchUriPathArgs>? = null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("qvsxrvhaqesgsiru")
    public suspend
    fun allQueryArguments(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("kxuffaopcbvtusvd")
    public suspend
    fun body(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("qqmdekjoiiefkakf")
    public suspend
    fun cookies(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("pelqnheelhydpmoi")
    public suspend
    fun headers(`value`: Output<List<WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("hgadpxlekicgjyiq")
    public suspend fun headers(
        vararg
        values: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("yjscrekhnsbjrlob")
    public suspend
    fun headers(values: List<Output<WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("tnwokmtxggujsjth")
    public suspend
    fun ja3Fingerprint(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("fhmetutwodvnmqej")
    public suspend
    fun jsonBody(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("ogqeryjocxgcgtly")
    public suspend
    fun method(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("dmrvhsyuqowclfrd")
    public suspend
    fun queryString(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("vlxqavabrderlnir")
    public suspend
    fun singleHeader(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("wtagkgeijslvacko")
    public suspend
    fun singleQueryArgument(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("rvnkvqaamyyugebg")
    public suspend
    fun uriPath(`value`: Output<WebAclRuleStatementRegexMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("ryswdsnvhvuyknbq")
    public suspend
    fun allQueryArguments(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("ohiscnwbsqhyikro")
    public suspend
    fun allQueryArguments(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("cdftvdmkdbqrhoqv")
    public suspend fun body(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("nrastwdmmvxoomie")
    public suspend
    fun body(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("fvexclmahsdqxlae")
    public suspend
    fun cookies(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("awvbyqgsdxocqcrn")
    public suspend
    fun cookies(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("lmcfhbvrpcxjtcij")
    public suspend
    fun headers(`value`: List<WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vaaphseybwdaxtti")
    public suspend
    fun headers(argument: List<suspend WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("cbknkcgpmkwvrlfc")
    public suspend fun headers(
        vararg
        argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("lwtewwpytgeprutb")
    public suspend
    fun headers(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("uikwtwrghujjaxal")
    public suspend fun headers(
        vararg
        values: WebAclRuleStatementRegexMatchStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("chkxifkpxnpwtyyh")
    public suspend
    fun ja3Fingerprint(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("wwkrknmbglkbwwgk")
    public suspend
    fun ja3Fingerprint(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("gbsmkkkocpdulmon")
    public suspend
    fun jsonBody(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("utynyujamhtqnqlp")
    public suspend
    fun jsonBody(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("goeyoqsawvyurhbj")
    public suspend
    fun method(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("jdsoxohocpfxedvn")
    public suspend
    fun method(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("wtlsismvjdmcxect")
    public suspend
    fun queryString(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("qjltnsabiymfdlpd")
    public suspend
    fun queryString(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("hsecueccyypugrvq")
    public suspend
    fun singleHeader(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("sjjyusnjbyfqsuum")
    public suspend
    fun singleHeader(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("dvhfyqavnoxvbrli")
    public suspend
    fun singleQueryArgument(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("vnmulwhpfvofatux")
    public suspend
    fun singleQueryArgument(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("eymcakjjptxxbmhb")
    public suspend
    fun uriPath(`value`: WebAclRuleStatementRegexMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("byhkqflwwoslbkfm")
    public suspend
    fun uriPath(argument: suspend WebAclRuleStatementRegexMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementRegexMatchStatementFieldToMatchArgs =
        WebAclRuleStatementRegexMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
