@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs>? = null,
    public val headers:
    Output<List<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs>? =
        null,
    public val jsonBody:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs>? = null,
    public val method:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs>? = null,
    public val queryString:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath:
    Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder internal
constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs>? =
        null

    private var body:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs>? = null

    private var cookies:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs>? = null

    private var headers:
        Output<List<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs>? =
        null

    private var jsonBody:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs>? = null

    private var method:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs>? = null

    private var queryString:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs>? =
        null

    private var singleQueryArgument:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs>? = null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("agetjnfkaltmakrk")
    public suspend
    fun allQueryArguments(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("vepfnasbdvarwcpj")
    public suspend
    fun body(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("jacqatjxgvigdxce")
    public suspend
    fun cookies(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("nsqratuwqcrkisjp")
    public suspend
    fun headers(`value`: Output<List<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("iqhkesbcyksrlnot")
    public suspend fun headers(
        vararg
        values: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vcpfpqarcgsxdrrc")
    public suspend
    fun headers(values: List<Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("iomvvjpswccaxhae")
    public suspend
    fun ja3Fingerprint(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("jpqfxagcapkfbved")
    public suspend
    fun jsonBody(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("rwiqurcpekcnawsh")
    public suspend
    fun method(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("jloauhyvpstxnxew")
    public suspend
    fun queryString(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("jnwgpnccfeuedffv")
    public suspend
    fun singleHeader(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("tqkrwqpajplgdyci")
    public suspend
    fun singleQueryArgument(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("tkobrxqmjxsgnipw")
    public suspend
    fun uriPath(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("wxftbbnfhtylklvn")
    public suspend
    fun allQueryArguments(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("nkshnkhcvowpnkrd")
    public suspend
    fun allQueryArguments(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("blcdjrkptxmgfpae")
    public suspend
    fun body(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("roltdegtkojtdqqs")
    public suspend
    fun body(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("tollkiklycgdofah")
    public suspend
    fun cookies(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("wgpdgalemjejaumr")
    public suspend
    fun cookies(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("uytkjyvggxdayutu")
    public suspend
    fun headers(`value`: List<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("bowulosbrwfnonki")
    public suspend
    fun headers(argument: List<suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("eyteoxxncplwovdh")
    public suspend fun headers(
        vararg
        argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("swbtiimovppklwhp")
    public suspend
    fun headers(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("kbmxtqvekhqpisgi")
    public suspend fun headers(
        vararg
        values: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("wawuvbexwfkngwcl")
    public suspend
    fun ja3Fingerprint(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("bxmdiyfvhwcxvdjh")
    public suspend
    fun ja3Fingerprint(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("akosqudilubyomyc")
    public suspend
    fun jsonBody(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("tyiwewbmlhbjtaoj")
    public suspend
    fun jsonBody(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("loubnxjbokjsyrom")
    public suspend
    fun method(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("chyfstvhwluybkxt")
    public suspend
    fun method(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("ndqkulqjrxcrqjgw")
    public suspend
    fun queryString(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("egfedfwxuopsvhpt")
    public suspend
    fun queryString(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("robcrpuyunopamis")
    public suspend
    fun singleHeader(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("xpgixqpyjnemihht")
    public suspend
    fun singleHeader(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("rvqxypspgroayqxb")
    public suspend
    fun singleQueryArgument(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("brxexufupjgubino")
    public suspend
    fun singleQueryArgument(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("qwewscpxaoihfgty")
    public suspend
    fun uriPath(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("uqajbgoveqxmaxvj")
    public suspend
    fun uriPath(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs =
        WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
