@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allow Instructs AWS WAF to allow the web request. See `allow` below for details.
 * @property block Instructs AWS WAF to block the web request. See `block` below for details.
 * @property captcha Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
 * @property challenge Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
 * @property count Instructs AWS WAF to count the web request and allow it. See `count` below for details.
 */
public data class WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs(
    public val allow:
    Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseAllowArgs>? =
        null,
    public val block:
    Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockArgs>? =
        null,
    public val captcha:
    Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCaptchaArgs>? =
        null,
    public val challenge:
    Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseChallengeArgs>? =
        null,
    public val count:
    Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCountArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .block(block?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captcha(captcha?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .challenge(challenge?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .count(count?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgsBuilder
internal constructor() {
    private var allow:
        Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseAllowArgs>? =
        null

    private var block:
        Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockArgs>? =
        null

    private var captcha:
        Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCaptchaArgs>? =
        null

    private var challenge:
        Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseChallengeArgs>? =
        null

    private var count:
        Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCountArgs>? =
        null

    /**
     * @param value Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("dkpkisjmugbwyurq")
    public suspend
    fun allow(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseAllowArgs>) {
        this.allow = value
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("pfgawffasdoqhqwq")
    public suspend
    fun block(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockArgs>) {
        this.block = value
    }

    /**
     * @param value Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("tycclohyahcshmva")
    public suspend
    fun captcha(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCaptchaArgs>) {
        this.captcha = value
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("ttrnbuyotuvpqabg")
    public suspend
    fun challenge(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseChallengeArgs>) {
        this.challenge = value
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("omqsqagfanrvucdp")
    public suspend
    fun count(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCountArgs>) {
        this.count = value
    }

    /**
     * @param value Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("dmftnixrqtmchhwa")
    public suspend
    fun allow(`value`: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseAllowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param argument Instructs AWS WAF to allow the web request. See `allow` below for details.
     */
    @JvmName("kljmbijispdsiqjn")
    public suspend
    fun allow(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseAllowArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseAllowArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("xrgwstdqunleputd")
    public suspend
    fun block(`value`: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.block = mapped
    }

    /**
     * @param argument Instructs AWS WAF to block the web request. See `block` below for details.
     */
    @JvmName("cnmvacidgtqmijao")
    public suspend
    fun block(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.block = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("chiguvlpaefcvmpl")
    public suspend
    fun captcha(`value`: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCaptchaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captcha = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
     */
    @JvmName("ckfwsswicwvjomdg")
    public suspend
    fun captcha(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCaptchaArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCaptchaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.captcha = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("cpexbhdsqoooyhcc")
    public suspend
    fun challenge(`value`: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseChallengeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.challenge = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
     */
    @JvmName("ajaicaecbajmkgpw")
    public suspend
    fun challenge(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseChallengeArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseChallengeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.challenge = mapped
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("lidwkytfniflkvof")
    public suspend
    fun count(`value`: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param argument Instructs AWS WAF to count the web request and allow it. See `count` below for details.
     */
    @JvmName("rmdfgvslvbfndoxw")
    public suspend
    fun count(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.count = mapped
    }

    internal fun build():
        WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs =
        WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs(
            allow = allow,
            block = block,
            captcha = captcha,
            challenge = challenge,
            count = count,
        )
}
