@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator Operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property size Size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementSizeConstraintStatementArgs(
    public val comparisonOperator: Output<String>,
    public val fieldToMatch: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs>? =
        null,
    public val size: Output<Int>,
    public val textTransformations:
    Output<List<WebAclRuleStatementSizeConstraintStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(size.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementSizeConstraintStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementSizeConstraintStatementArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var fieldToMatch: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs>? =
        null

    private var size: Output<Int>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementSizeConstraintStatementTextTransformationArgs>>? = null

    /**
     * @param value Operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
     */
    @JvmName("xifdaiyqjevsnqxb")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("kcakvqcgexgpueqv")
    public suspend
    fun fieldToMatch(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
     */
    @JvmName("wkncecpcywhhjjiw")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("oupflyclmikfduru")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementSizeConstraintStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("fnvjcpxfihrogidi")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementSizeConstraintStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("hlwqyxifyhdlpqeg")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementSizeConstraintStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Operator to use to compare the request part to the size setting. Valid values include: `EQ`, `NE`, `LE`, `LT`, `GE`, or `GT`.
     */
    @JvmName("eybhroapubljpond")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("fmsegxyaseogwbon")
    public suspend
    fun fieldToMatch(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("fxuaomclllopaoeo")
    public suspend
    fun fieldToMatch(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Size, in bytes, to compare to the request part, after any transformations. Valid values are integers between 0 and 21474836480, inclusive.
     */
    @JvmName("pirruqxqvpuqiutn")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("olmabnrwdvkfaetw")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementSizeConstraintStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("tpqnsocuptxmsstr")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementSizeConstraintStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSizeConstraintStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("fdhdraggohxdilin")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementSizeConstraintStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSizeConstraintStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("gbgkdteskmfydccx")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementSizeConstraintStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementSizeConstraintStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("bsaqlidllidfjtil")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementSizeConstraintStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementSizeConstraintStatementArgs =
        WebAclRuleStatementSizeConstraintStatementArgs(
            comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
            fieldToMatch = fieldToMatch,
            size = size ?: throw PulumiNullFieldException("size"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
