@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs>? =
        null,
    public val headers:
    Output<List<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>? = null,
    public val ja3Fingerprint:
    Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString:
    Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs>? = null,
    public val singleHeader:
    Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument:
    Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementSizeConstraintStatementFieldToMatchArgsBuilder internal
constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs>? =
        null

    private var headers:
        Output<List<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>? = null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("gpilqrdqrhopmpfp")
    public suspend
    fun allQueryArguments(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("udiibhgqxlcsoyqy")
    public suspend
    fun body(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("uuxsebtchhkfennv")
    public suspend
    fun cookies(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("nsdphnxnnellrdqe")
    public suspend
    fun headers(`value`: Output<List<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("otjdqnoxsquyrqah")
    public suspend fun headers(
        vararg
        values: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("bhnuoffowsdlvdus")
    public suspend
    fun headers(values: List<Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("djxxasxgasogxbox")
    public suspend
    fun ja3Fingerprint(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("rplhiqbfkakruhsd")
    public suspend
    fun jsonBody(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("lvuafetnlwlvqxfx")
    public suspend
    fun method(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("xnxybvesduggtwat")
    public suspend
    fun queryString(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("cjanojwbbqpvjmif")
    public suspend
    fun singleHeader(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("cjggjwkmbbcfhvkx")
    public suspend
    fun singleQueryArgument(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("jxrmqsgrxnvoekvo")
    public suspend
    fun uriPath(`value`: Output<WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("ghwdsbrpdocqxrfi")
    public suspend
    fun allQueryArguments(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("nphjpnoajqccbhib")
    public suspend
    fun allQueryArguments(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("nswldacqwweemuho")
    public suspend
    fun body(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("esurloyonedfncpg")
    public suspend
    fun body(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("ttwygbsinnjucykr")
    public suspend
    fun cookies(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("txrjojpqqqippwas")
    public suspend
    fun cookies(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("dsbsywtbjaovgdyc")
    public suspend
    fun headers(`value`: List<WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("gvrfugxvpsfkmasw")
    public suspend
    fun headers(argument: List<suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("dogdpwprwngememi")
    public suspend fun headers(
        vararg
        argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("xopbpxifrxsckdty")
    public suspend
    fun headers(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("rbhmivnlmjiaykqj")
    public suspend fun headers(
        vararg
        values: WebAclRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("keudyexbldvticua")
    public suspend
    fun ja3Fingerprint(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("dewmswjriqpibeoc")
    public suspend
    fun ja3Fingerprint(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("ifxbfrnwbyfnbubh")
    public suspend
    fun jsonBody(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("yjamqwtrcpelnusm")
    public suspend
    fun jsonBody(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("rscjowuwebeirefs")
    public suspend
    fun method(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("gdcpicwqyjhcloat")
    public suspend
    fun method(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("asswhshmvifpkchh")
    public suspend
    fun queryString(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("ugihmlwsrxclvjsn")
    public suspend
    fun queryString(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("ymuhvbcgfmcaenal")
    public suspend
    fun singleHeader(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("yphmjibtublmeqsd")
    public suspend
    fun singleHeader(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("kwegfsovsksecalj")
    public suspend
    fun singleQueryArgument(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("vlpcyojtkmvrktjl")
    public suspend
    fun singleQueryArgument(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("rathsxwqamyxqgbx")
    public suspend
    fun uriPath(`value`: WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("fvsjxmrpxyrrexju")
    public suspend
    fun uriPath(argument: suspend WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSizeConstraintStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs =
        WebAclRuleStatementSizeConstraintStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
