@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the query header to inspect. This setting must be provided as lower case characters.
 */
public data class WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs(
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder internal
constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the query header to inspect. This setting must be provided as lower case characters.
     */
    @JvmName("yfpkcutcrvdsitpa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the query header to inspect. This setting must be provided as lower case characters.
     */
    @JvmName("tekcndlqtiltubvq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs =
        WebAclRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs(
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
