@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementSqliMatchStatementArgs(
    public val fieldToMatch: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchArgs>? = null,
    public val textTransformations:
    Output<List<WebAclRuleStatementSqliMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementSqliMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementSqliMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchArgs>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementSqliMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("mypofriysaotuyue")
    public suspend
    fun fieldToMatch(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ywlmpqejlcumfjho")
    public suspend
    fun textTransformations(`value`: Output<List<WebAclRuleStatementSqliMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("aqlhndbvnxfjmtuj")
    public suspend fun textTransformations(
        vararg
        values: Output<WebAclRuleStatementSqliMatchStatementTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("iuneavxohmpbpxhs")
    public suspend
    fun textTransformations(values: List<Output<WebAclRuleStatementSqliMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("hpeokonrlqfitcou")
    public suspend fun fieldToMatch(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("egfiqvnrscokpkaa")
    public suspend
    fun fieldToMatch(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementSqliMatchStatementFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("mphmpsrwgogceidf")
    public suspend
    fun textTransformations(`value`: List<WebAclRuleStatementSqliMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("upjdfiuuunotbgsw")
    public suspend
    fun textTransformations(argument: List<suspend WebAclRuleStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("rovvfbaevtnvouov")
    public suspend fun textTransformations(
        vararg
        argument: suspend WebAclRuleStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("qscmbhodubbcwclb")
    public suspend
    fun textTransformations(argument: suspend WebAclRuleStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ttgktuqopleceyht")
    public suspend fun textTransformations(
        vararg
        values: WebAclRuleStatementSqliMatchStatementTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementSqliMatchStatementArgs =
        WebAclRuleStatementSqliMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
