@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementSqliMatchStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchCookiesArgs>? = null,
    public val headers: Output<List<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<WebAclRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchMethodArgs>? = null,
    public val queryString: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader:
    Output<WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument:
    Output<WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchUriPathArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementSqliMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementSqliMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementSqliMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchCookiesArgs>? = null

    private var headers: Output<List<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchMethodArgs>? = null

    private var queryString: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchUriPathArgs>? = null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("yhktfsmjeeuvyjoj")
    public suspend
    fun allQueryArguments(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("lmqjxcqaoldapkjh")
    public suspend
    fun body(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("arlwwcsseeuleppt")
    public suspend
    fun cookies(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("hrxcccybraawnstm")
    public suspend
    fun headers(`value`: Output<List<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("yuiwbtcfvfprieqc")
    public suspend fun headers(
        vararg
        values: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("jrtsophkdxsoyrtt")
    public suspend
    fun headers(values: List<Output<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("iuahovnrhowwmemv")
    public suspend
    fun ja3Fingerprint(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("aqsutppxuvyqtsdc")
    public suspend
    fun jsonBody(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("jydatruwejqooxsj")
    public suspend
    fun method(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("lqsbkjaiyiqrhkcr")
    public suspend
    fun queryString(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("jrpxlmgexwludwyb")
    public suspend
    fun singleHeader(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("wjiwulibswlwjbsq")
    public suspend
    fun singleQueryArgument(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("jjftevffpreoimtw")
    public suspend
    fun uriPath(`value`: Output<WebAclRuleStatementSqliMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("ukgfgipmhilvsoys")
    public suspend
    fun allQueryArguments(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("yrwlpalmfhytwlca")
    public suspend
    fun allQueryArguments(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("trseicfunrcddqjb")
    public suspend fun body(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("snvwwdiinlkgxetw")
    public suspend
    fun body(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("lkrwuwmbcmdppwom")
    public suspend
    fun cookies(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("bsiiwgqhllemvmbq")
    public suspend
    fun cookies(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("wbvjtbtvnetuwaru")
    public suspend
    fun headers(`value`: List<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("fkexjpxujrkghnav")
    public suspend
    fun headers(argument: List<suspend WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("kmaplsjfvumcsmkq")
    public suspend fun headers(
        vararg
        argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("tpartevcftuagiob")
    public suspend
    fun headers(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vuwcjspaajtuoorb")
    public suspend fun headers(
        vararg
        values: WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("rhgaqkqwuovovwtm")
    public suspend
    fun ja3Fingerprint(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("kpkjviijoqnpojmf")
    public suspend
    fun ja3Fingerprint(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("pqgjevgtpmnxeoqa")
    public suspend
    fun jsonBody(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("vjpceotmgujmastu")
    public suspend
    fun jsonBody(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("nyxdvmtfwubycxxp")
    public suspend fun method(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("ikrwrypoovacyhve")
    public suspend
    fun method(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("dafcfvotdtdrkyne")
    public suspend
    fun queryString(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("nwthudninavufbqm")
    public suspend
    fun queryString(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("htfqairrxweocmja")
    public suspend
    fun singleHeader(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("kccjqiavruujoobm")
    public suspend
    fun singleHeader(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("cxgbiafcdapgyjxk")
    public suspend
    fun singleQueryArgument(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("efwdiooqddbxqnlh")
    public suspend
    fun singleQueryArgument(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("cccbqydsjvuwjprj")
    public suspend
    fun uriPath(`value`: WebAclRuleStatementSqliMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("igprpqxtdyvfsemf")
    public suspend
    fun uriPath(argument: suspend WebAclRuleStatementSqliMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementSqliMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementSqliMatchStatementFieldToMatchArgs =
        WebAclRuleStatementSqliMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
